import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const StarOutlineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M3.80296 15.4001L7.99996 12.8471L12.197 15.4001C12.3065 15.4666 12.4332 15.4992 12.5612 15.4939C12.6893 15.4886 12.8129 15.4456 12.9165 15.3703C13.0202 15.295 13.0992 15.1907 13.1438 15.0705C13.1884 14.9504 13.1964 14.8198 13.167 14.6951L12.037 9.91506L15.761 6.71206C15.8582 6.62855 15.9287 6.51813 15.9633 6.39469C15.998 6.27126 15.9954 6.14032 15.9559 6.01836C15.9163 5.8964 15.8416 5.78886 15.7411 5.70927C15.6405 5.62968 15.5187 5.58159 15.391 5.57106L10.495 5.16906L8.59996 0.637061C8.5506 0.518606 8.46729 0.41741 8.36051 0.346228C8.25374 0.275045 8.12828 0.237061 7.99996 0.237061C7.87163 0.237061 7.74618 0.275045 7.6394 0.346228C7.53263 0.41741 7.44931 0.518606 7.39996 0.637061L5.50496 5.16906L0.609956 5.57106C0.482402 5.58178 0.360853 5.62993 0.260553 5.70946C0.160253 5.78899 0.0856685 5.89636 0.0461525 6.01812C0.00663647 6.13987 0.00394858 6.27058 0.038426 6.39385C0.0729033 6.51712 0.143011 6.62747 0.239956 6.71106L3.96396 9.91406L2.83396 14.6941C2.80424 14.8188 2.8121 14.9496 2.85655 15.0699C2.901 15.1902 2.98006 15.2947 3.08376 15.3702C3.18747 15.4457 3.31119 15.4888 3.43934 15.4941C3.5675 15.4994 3.69436 15.4667 3.80396 15.4001H3.80296ZM8.51996 11.1731C8.36328 11.0777 8.18338 11.0272 7.99996 11.0272C7.81653 11.0272 7.63663 11.0777 7.47996 11.1731L5.06496 12.6431L5.71496 9.89106C5.7572 9.71286 5.7497 9.52649 5.69327 9.35226C5.63684 9.17804 5.53365 9.02265 5.39496 8.90306L3.24996 7.06006L6.06796 6.82906C6.2505 6.81392 6.42538 6.74893 6.57351 6.64118C6.72164 6.53343 6.83733 6.38707 6.90796 6.21806L7.99996 3.60906L9.08996 6.21806C9.16081 6.38702 9.27671 6.53327 9.42502 6.64085C9.57333 6.74842 9.74835 6.81318 9.93096 6.82806L12.749 7.06006L10.605 8.90306C10.4663 9.02265 10.3631 9.17804 10.3066 9.35226C10.2502 9.52649 10.2427 9.71286 10.285 9.89106L10.935 12.6421L8.51996 11.1731Z"
            fill={props.fill}
        />
    </svg>
);

StarOutlineIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default StarOutlineIcon;
