import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const StopIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8 16C12.4183 16 16 12.4183 16 8C16 3.58172 12.4183 0 8 0C3.58172 0 0 3.58172 0 8C0 12.4183 3.58172 16 8 16ZM12.5714 6.85714H3.42857V9.14286H12.5714V6.85714Z"
            fill={props.fill}
        />
    </svg>
);

StopIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default StopIcon;
