import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SwimmingPoolIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M13.9765 6.66651C12.8729 6.65292 12.0012 5.76704 12 4.65614C11.9988 3.54464 12.8678 2.67155 13.9808 2.66668C15.1061 2.66161 16.0176 3.57223 15.9997 4.68435C15.9827 5.7713 15.0553 6.6799 13.9765 6.66651ZM13.9742 12.197C12.9539 11.5622 11.4725 11.0527 9.44201 11.7719C8.72807 12.0248 8.12109 12.3556 7.45734 12.6422C4.84977 13.7682 2.29961 13.499 0 11.976L0.646745 11.5886C2.34858 12.6585 4.95043 12.0897 7.00248 11.1073C8.00309 10.6284 9.01446 10.1728 10.1189 9.95459C11.406 9.69995 12.594 9.90114 13.7201 10.3849C13.8481 10.9703 13.9342 11.576 13.9742 12.197ZM13.999 13.1576C13.9983 13.2163 13.9971 13.2749 13.9956 13.3333H7.89827C8.91919 12.8364 10.254 12.2467 11.3518 12.2467C12.509 12.2467 13.2231 12.6707 13.999 13.1576ZM4.32376 10.8748C3.71881 10.8581 2.73574 10.6048 2.23683 10.1989L7.65576 5.8933C7.68697 5.8685 7.7159 5.84095 7.74218 5.81098C7.98499 5.53421 7.95746 5.11301 7.68068 4.8702L7.68069 4.87019C7.3018 4.5378 6.71675 4.25139 5.92553 4.01095C4.89323 3.69732 3.62931 3.74988 2.79394 3.83924L2.73733 3.0463C3.29524 2.90691 5.89045 2.47296 7.91679 3.13819C9.48467 3.65293 10.9617 4.7303 11.87 6.07457C12.9994 7.74572 13.4189 9.42835 13.4189 9.42835C11.6127 8.45962 8.9754 9.32011 7.70391 9.91739C6.62975 10.4222 5.55658 10.9087 4.32376 10.8748Z"
            fill={props.fill}
        />
    </svg>
);

SwimmingPoolIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default SwimmingPoolIcon;
