import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TvIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <g clipPath="url(#aa3e7131__clip0_20315_4851)">
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M1.0477 3.11551H14.7583C15.3369 3.11551 15.806 3.58458 15.806 4.16321V14.5298C15.806 15.1085 15.3369 15.5775 14.7583 15.5775H1.0477C0.46907 15.5775 0 15.1085 0 14.5298V4.16321C0 3.58458 0.46907 3.11551 1.0477 3.11551ZM2.82718 5.1925H10.6733C11.0876 5.1925 11.4235 5.52837 11.4235 5.9427V12.7503C11.4235 13.1647 11.0876 13.5006 10.6733 13.5006H2.82718C2.41285 13.5006 2.07697 13.1647 2.07697 12.7503V5.9427C2.07697 5.52837 2.41285 5.1925 2.82718 5.1925ZM13.1088 5.19248C13.4659 5.19248 13.7555 5.48203 13.7555 5.83921V10.7768C13.7555 11.1339 13.4659 11.4235 13.1088 11.4235C12.7516 11.4235 12.462 11.1339 12.462 10.7768V5.83921C12.462 5.48203 12.7516 5.19248 13.1088 5.19248ZM13.641 12.8409C13.641 13.2052 13.3457 13.5005 12.9813 13.5005C12.617 13.5005 12.3217 13.2052 12.3217 12.8409C12.3217 12.4765 12.617 12.1812 12.9813 12.1812C13.3457 12.1812 13.641 12.4765 13.641 12.8409Z"
                fill={props.fill}
            />
            <path
                fillRule="evenodd"
                clipRule="evenodd"
                d="M11.8688 0.287993C12.0669 0.585182 11.9866 0.986715 11.6894 1.18484L8.15959 4.42285C7.94851 4.56358 7.67463 4.56788 7.45922 4.43387L4.14664 1.38988C3.84336 1.2012 3.75046 0.802392 3.93914 0.499117C4.12782 0.195842 4.52663 0.102943 4.82991 0.291622L7.78875 3.11554L10.9719 0.108623C11.2691 -0.0895035 11.6706 -0.00919685 11.8688 0.287993Z"
                fill={props.fill}
            />
        </g>
        <defs>
            <clipPath id="aa3e7131__clip0_20315_4851">
                <rect
                    width={15.22}
                    height={15.4068}
                    fill="white"
                    transform="scale(1.0385)"
                />
            </clipPath>
        </defs>
    </svg>
);

TvIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default TvIcon;
