import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ViewOnCityIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6.85713 14.8571H2.74285C2.49038 14.8571 2.28571 14.6524 2.28571 14.4V2.74282C2.28571 2.49035 2.49038 2.28568 2.74285 2.28568H3.42856V1.59997C3.42856 1.34749 3.63323 1.14282 3.88571 1.14282H12.1143C12.3668 1.14282 12.5714 1.34749 12.5714 1.59997V2.28568H13.2571C13.5096 2.28568 13.7143 2.49035 13.7143 2.74282V14.4C13.7143 14.6524 13.5096 14.8571 13.2571 14.8571H9.14285V11.8857C9.14285 11.6332 8.93818 11.4285 8.68571 11.4285H7.31428C7.0618 11.4285 6.85713 11.6332 6.85713 11.8857V14.8571ZM4.57142 3.42854V5.71425H6.85713V3.42854H4.57142ZM9.14285 3.42854V5.71425H11.4286V3.42854H9.14285ZM4.57142 6.85711V9.14282H6.85713V6.85711H4.57142ZM9.14285 6.85711V9.14282H11.4286V6.85711H9.14285Z"
            fill={props.fill}
        />
    </svg>
);

ViewOnCityIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ViewOnCityIcon;
