import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ViewOnGardenIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M8.72537 2.85095C7.98509 1.90064 6.9814 0.950318 5.71431 0C2.66669 2.28571 1.14288 4.57143 1.14288 6.85714C1.14288 10.2857 3.4286 11.4286 5.71431 11.4286C5.84586 11.4286 5.97742 11.4248 6.10853 11.417L7.61601 7.89954C7.07655 7.5762 6.81415 6.91135 7.02128 6.28996C7.05423 6.19838 7.05423 6.19838 7.09568 6.11033L8.72537 2.85095Z"
            fill={props.fill}
        />
        <path
            d="M6.40003 12.5714L6.59609 15.5124C6.61368 15.7763 6.4044 16 6.13996 16H5.28866C5.02422 16 4.81494 15.7763 4.83253 15.5124L5.0286 12.5714H6.40003Z"
            fill={props.fill}
        />
        <path
            d="M15.7886 12.078L14.1661 8.29219L11.79 9.08421C11.5554 9.16241 11.3018 9.16241 11.0672 9.08421L8.69113 8.29219L7.06862 12.078C7.05901 12.1005 7.05122 12.1236 7.04531 12.1473C6.98407 12.3922 7.13299 12.6404 7.37793 12.7016L10.618 13.5116L10.5342 15.5238C10.5339 15.5302 10.5338 15.5365 10.5338 15.5429C10.5338 15.7953 10.7384 16 10.9909 16H11.8663L11.8766 15.9999L11.8853 15.9996C12.1376 15.9891 12.3336 15.7761 12.323 15.5238L12.2392 13.5116L15.4793 12.7016C15.5029 12.6957 15.5261 12.6879 15.5485 12.6783C15.7805 12.5789 15.888 12.3101 15.7886 12.078Z"
            fill={props.fill}
        />
        <path
            d="M14.7393 6.62142L11.633 0.408881C11.6109 0.364646 11.5751 0.328778 11.5308 0.306661C11.4179 0.250206 11.2806 0.295972 11.2242 0.408881L8.11789 6.62142C8.11305 6.63109 8.10891 6.6411 8.10549 6.65136C8.06557 6.77112 8.13029 6.90056 8.25005 6.94048L11.4286 8L14.6071 6.94048C14.6174 6.93706 14.6274 6.93292 14.6371 6.92808C14.75 6.87163 14.7958 6.73433 14.7393 6.62142Z"
            fill={props.fill}
        />
    </svg>
);

ViewOnGardenIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ViewOnGardenIcon;
