import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ViewOnHippodromeIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M5.94286 0.914286C5.94286 1.41923 6.3522 1.82857 6.85714 1.82857C7.36209 1.82857 7.77143 1.41923 7.77143 0.914286C7.77143 0.40934 7.36209 0 6.85714 0C6.3522 0 5.94286 0.40934 5.94286 0.914286Z"
            fill={props.fill}
        />
        <path
            d="M6.62857 2.51429C5.67619 2.51429 5.71429 4.57272 5.71429 4.57272L5.71177 5.71669L3.42857 5.71429C0 5.71429 0 8 0 10.0571C0.914286 10.2857 1.91224 9.82348 2.05714 9.01616C2.08216 8.81463 2.04112 8.55672 1.99735 8.28168C1.86087 7.42408 1.6979 6.4 3.42857 6.4C2.05714 7.31429 3.2 9.71428 3.2 9.71428C3.23817 10.0006 2.93789 10.3336 2.71717 10.5783C2.68623 10.6127 2.65686 10.6452 2.6302 10.6757L1.61995 11.8303C1.45855 12.0147 1.36073 12.2462 1.34092 12.4905C1.34092 12.4905 1.15861 14.7398 1.15861 14.7429C1.15861 14.806 1.20978 14.8571 1.2729 14.8571H1.73468C1.78925 14.8571 1.8362 14.8186 1.84679 14.765L2.18101 13.0754C2.24441 12.7549 2.44198 12.4768 2.7238 12.3115L4.22857 11.4286L4.54044 12.4773C4.55939 12.541 4.58386 12.603 4.61358 12.6625L5.67874 14.7939C5.6981 14.8327 5.73768 14.8571 5.78097 14.8571C5.78097 14.8571 6.26845 14.8555 6.27915 14.8523C6.33958 14.834 6.37379 14.7703 6.35556 14.7098L5.75905 12.7329C5.72674 12.6258 5.71032 12.5146 5.71032 12.4028V10.5143C5.71032 10.388 5.81266 10.2857 5.93889 10.2857C5.93889 10.2857 8.90013 10.2866 8.91135 10.2882C9.03619 10.307 9.12221 10.4234 9.10349 10.5482C9.10349 10.5482 8.47556 14.7372 8.47556 14.7429C8.47556 14.806 8.52673 14.8571 8.58985 14.8571H9.05929C9.10906 14.8571 9.15311 14.8249 9.1682 14.7775L10.6412 10.1479C10.652 10.1142 10.6778 10.0873 10.711 10.0752C10.7703 10.0536 10.8359 10.0842 10.8575 10.1435L12.5466 14.782C12.563 14.8271 12.6059 14.8571 12.654 14.8571C12.654 14.8571 13.1353 14.8564 13.1427 14.8549C13.2045 14.8425 13.2447 14.7823 13.2323 14.7204L12.4908 11.0213C12.2438 9.78882 12.3108 8.51403 12.6857 7.31428L13.1294 5.89449C13.1416 5.85544 13.1738 5.82589 13.2137 5.81702C13.2753 5.80332 13.3364 5.84217 13.35 5.90379L13.7143 7.54286C13.805 7.81862 14.0377 8 14.3247 8H14.7215C14.7908 8 14.8486 7.94615 14.8543 7.87615L15.3143 4.11429L15.7019 3.9155C15.8846 3.82295 16 3.63377 16 3.42683H14C12.1648 3.42683 10.5461 3.97795 9.58648 5.40752C9.57208 5.42896 9.5484 5.46112 9.52134 5.49786C9.47012 5.5674 9.4068 5.65337 9.37143 5.71429C8.54111 5.71429 8 5.11572 8 4.34286V4.33098C8.00001 3.19562 8.00001 2.51429 7.33333 2.51429H6.62857Z"
            fill={props.fill}
        />
    </svg>
);

ViewOnHippodromeIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ViewOnHippodromeIcon;
