import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ViewOnMountainIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 17 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M5.4622 0.956997L0.00415039 12.4615L8.00178 14.7479L16.0042 12.4615L10.5157 4.78295C10.402 4.6239 10.1658 4.62339 10.0514 4.78195L6.03244 10.3537L7.85834 4.92768L5.97872 0.957214C5.87556 0.739298 5.56554 0.739168 5.4622 0.956997Z"
            fill={props.fill}
        />
    </svg>
);

ViewOnMountainIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ViewOnMountainIcon;
