import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ViewOnSeaIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M1.14288 4.3429H2.28574C3.37652 4.3429 4.33858 3.95576 5.14288 3.21208C5.94718 3.95576 6.90924 4.3429 8.00003 4.3429C9.09081 4.3429 10.0529 3.95576 10.8572 3.21208C11.6615 3.95576 12.6235 4.3429 13.7143 4.3429H14.8572V2.51433H13.7143C12.8795 2.51433 12.1979 2.13262 11.6012 1.29719L10.8572 0.255615L10.1132 1.29719C9.51645 2.13262 8.83484 2.51433 8.00003 2.51433C7.16521 2.51433 6.4836 2.13262 5.88687 1.29719L5.14288 0.255615L4.3989 1.29719C3.80216 2.13262 3.12055 2.51433 2.28574 2.51433H1.14288V4.3429Z"
            fill={props.fill}
        />
        <path
            d="M2.28574 9.48575H1.14288V7.65718H2.28574C3.12055 7.65718 3.80216 7.27548 4.3989 6.44005L5.14288 5.39847L5.88687 6.44005C6.4836 7.27548 7.16521 7.65718 8.00003 7.65718C8.83484 7.65718 9.51645 7.27548 10.1132 6.44005L10.8572 5.39847L11.6012 6.44005C12.1979 7.27548 12.8795 7.65718 13.7143 7.65718H14.8572V9.48575H13.7143C12.6235 9.48575 11.6615 9.09861 10.8572 8.35494C10.0529 9.09861 9.09081 9.48575 8.00003 9.48575C6.90924 9.48575 5.94718 9.09861 5.14288 8.35494C4.33858 9.09861 3.37652 9.48575 2.28574 9.48575Z"
            fill={props.fill}
        />
        <path
            d="M2.28574 14.6286H1.14288V12.8H2.28574C3.12055 12.8 3.80216 12.4183 4.3989 11.5829L5.14288 10.5413L5.88687 11.5829C6.4836 12.4183 7.16521 12.8 8.00003 12.8C8.83484 12.8 9.51645 12.4183 10.1132 11.5829L10.8572 10.5413L11.6012 11.5829C12.1979 12.4183 12.8795 12.8 13.7143 12.8H14.8572V14.6286H13.7143C12.6235 14.6286 11.6615 14.2415 10.8572 13.4978C10.0529 14.2415 9.09081 14.6286 8.00003 14.6286C6.90924 14.6286 5.94718 14.2415 5.14288 13.4978C4.33858 14.2415 3.37652 14.6286 2.28574 14.6286Z"
            fill={props.fill}
        />
    </svg>
);

ViewOnSeaIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ViewOnSeaIcon;
