import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ViewOnStadiumIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 16"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M4.57143 2.28568V3.6335C5.59924 3.4961 6.7574 3.42855 8 3.42855C9.2426 3.42855 10.4008 3.4961 11.4286 3.6335V2.28568H10.5143C10.3881 2.28568 10.2857 2.18334 10.2857 2.05711V1.37139C10.2857 1.24516 10.3881 1.14282 10.5143 1.14282H13.4857C13.612 1.14282 13.7143 1.24516 13.7143 1.37139V2.05711C13.7143 2.18334 13.612 2.28568 13.4857 2.28568H12.5714V3.82679C14.6739 4.26691 16 5.07738 16 6.28569C16 7.15655 15.3006 7.81598 14.1291 8.28455C13.9086 6.30512 11.5097 5.25712 8 5.25712C4.49029 5.25712 2.09143 6.30512 1.872 8.28455C0.699429 7.81598 0 7.15655 0 6.28569C0 5.07738 1.32614 4.26691 3.42857 3.82679V2.28568H2.51429C2.38805 2.28568 2.28571 2.18334 2.28571 2.05711V1.37139C2.28571 1.24516 2.38805 1.14282 2.51429 1.14282H5.48571C5.61195 1.14282 5.71429 1.24516 5.71429 1.37139V2.05711C5.71429 2.18334 5.61195 2.28568 5.48571 2.28568H4.57143Z"
            fill={props.fill}
        />
        <path
            d="M8 7.42855C9.61829 7.42855 11.0434 7.94169 11.1886 8.96912C11.9531 8.87655 12.6446 8.74398 13.256 8.57598C13.256 8.57464 13.2564 8.57369 13.2567 8.57291L13.2571 8.5714C13.2571 7.09712 11.2366 6.1714 8 6.1714C4.76343 6.1714 2.74286 7.09712 2.74286 8.5714C2.74286 8.57188 2.74305 8.57235 2.74328 8.57291C2.74361 8.57369 2.744 8.57464 2.744 8.57598C3.35543 8.74398 4.04686 8.87655 4.81143 8.96912C4.95657 7.94169 6.38171 7.42855 8 7.42855Z"
            fill={props.fill}
        />
        <path
            d="M9.98082 14.7804L9.27271 11.9479C9.19639 11.6427 8.92212 11.4285 8.60747 11.4285H7.39253C7.07788 11.4285 6.80361 11.6427 6.72729 11.9479L6.01918 14.7804C1.75097 14.4294 0 12.929 0 11.4285V8.26233C1.37609 9.49266 4.22558 10.0571 8 10.0571C11.7744 10.0571 14.6239 9.49266 16 8.26233V11.4285C16 12.929 14.249 14.4294 9.98082 14.7804Z"
            fill={props.fill}
        />
    </svg>
);

ViewOnStadiumIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default ViewOnStadiumIcon;
