import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const WatchIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 16 17"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M8 16.0031C5.87827 16.0031 3.84344 15.1602 2.34315 13.6599C0.842855 12.1596 0 10.1248 0 8.00305C0 5.88132 0.842855 3.84649 2.34315 2.3462C3.84344 0.845907 5.87827 0.00305176 8 0.00305176C10.1217 0.00305176 12.1566 0.845907 13.6569 2.3462C15.1571 3.84649 16 5.88132 16 8.00305C16 10.1248 15.1571 12.1596 13.6569 13.6599C12.1566 15.1602 10.1217 16.0031 8 16.0031ZM8 14.0031C9.5913 14.0031 11.1174 13.3709 12.2426 12.2457C13.3679 11.1205 14 9.59435 14 8.00305C14 6.41175 13.3679 4.88563 12.2426 3.76041C11.1174 2.63519 9.5913 2.00305 8 2.00305C6.4087 2.00305 4.88258 2.63519 3.75736 3.76041C2.63214 4.88563 2 6.41175 2 8.00305C2 9.59435 2.63214 11.1205 3.75736 12.2457C4.88258 13.3709 6.4087 14.0031 8 14.0031ZM11.357 10.2671C11.4935 10.0398 11.5342 9.76752 11.4701 9.51024C11.406 9.25295 11.2423 9.03167 11.015 8.89505L9 7.68705V5.00305C9 4.73784 8.89464 4.48348 8.70711 4.29595C8.51957 4.10841 8.26522 4.00305 8 4.00305C7.73478 4.00305 7.48043 4.10841 7.29289 4.29595C7.10536 4.48348 7 4.73784 7 5.00305V8.25305C7.00014 8.4257 7.04497 8.59537 7.13014 8.74555C7.2153 8.89574 7.3379 9.02131 7.486 9.11005L9.986 10.6101C10.2133 10.7462 10.4854 10.7865 10.7425 10.7222C10.9995 10.6579 11.2206 10.4942 11.357 10.2671Z"
            fill={props.fill}
        />
    </svg>
);

WatchIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default WatchIcon;
