import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const WfIcon = (props: IIconProps): ReactElement => (
    <svg viewBox="0 0 16 16" fill="none" focusable={false} {...props}>
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M.5 6.043L1.864 7.49A8.799 8.799 0 018 5c2.38 0 4.541.947 6.136 2.49L15.5 6.043A10.754 10.754 0 008 3C5.091 3 2.45 4.158.5 6.043zm12.273 2.894A6.843 6.843 0 008 7a6.843 6.843 0 00-4.773 1.937l1.364 1.446a4.888 4.888 0 016.818 0l1.364-1.446zm-2.727 2.893a2.933 2.933 0 00-4.091 0L8 14l2.046-2.17z"
            fill={props.fill}
        />
    </svg>
);

WfIcon.defaultProps = {
    width: 16,
    height: 16,
    fill: 'currentColor',
};

export default WfIcon;
