import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ArrowBottomIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M11.9999 14.586L18.2929 8.293C18.4815 8.11084 18.7341 8.01005 18.9963 8.01233C19.2585 8.01461 19.5093 8.11978 19.6947 8.30518C19.8801 8.49059 19.9853 8.7414 19.9876 9.0036C19.9899 9.2658 19.8891 9.5184 19.7069 9.707L13.0609 16.354C12.9216 16.4934 12.7562 16.604 12.5742 16.6794C12.3921 16.7549 12.197 16.7937 11.9999 16.7937C11.8029 16.7937 11.6077 16.7549 11.4257 16.6794C11.2436 16.604 11.0782 16.4934 10.9389 16.354L4.29292 9.707C4.11076 9.5184 4.00997 9.2658 4.01224 9.0036C4.01452 8.7414 4.11969 8.49059 4.3051 8.30518C4.49051 8.11977 4.74132 8.01461 5.00352 8.01233C5.26571 8.01005 5.51832 8.11084 5.70692 8.293L11.9999 14.586Z"
            fill={props.fill}
        />
    </svg>
);

ArrowBottomIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default ArrowBottomIcon;
