import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ArrowLeftIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M9.41398 12L15.707 18.293C15.8891 18.4816 15.9899 18.7342 15.9877 18.9964C15.9854 19.2586 15.8802 19.5094 15.6948 19.6948C15.5094 19.8802 15.2586 19.9854 14.9964 19.9877C14.7342 19.9899 14.4816 19.8892 14.293 19.707L7.64598 13.061C7.50659 12.9217 7.39601 12.7563 7.32057 12.5742C7.24513 12.3922 7.2063 12.1971 7.2063 12C7.2063 11.8029 7.24513 11.6078 7.32057 11.4257C7.39601 11.2437 7.50659 11.0783 7.64598 10.939L14.293 4.293C14.4816 4.11084 14.7342 4.01004 14.9964 4.01232C15.2586 4.0146 15.5094 4.11977 15.6948 4.30518C15.8802 4.49059 15.9854 4.7414 15.9877 5.0036C15.9899 5.26579 15.8891 5.5184 15.707 5.707L9.41398 12Z"
            fill={props.fill}
        />
    </svg>
);

ArrowLeftIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default ArrowLeftIcon;
