import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BoatIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M13.0696 0.417801L13.7 4H10.3L10.9304 0.417801C10.9705 0.176707 11.1791 0 11.4236 0H12.5764C12.8209 0 13.0295 0.176707 13.0696 0.417801Z"
            fill={props.fill}
        />
        <path
            d="M3.94425 8.45025L3.5 12.6L11.3156 10.0485C11.7577 9.88799 12.2423 9.88799 12.6844 10.0485L20.5 12.6L20.0558 8.45025C20.0302 8.19465 19.8148 8 19.5576 8H15.6295C15.5189 8 15.4292 7.91046 15.4292 7.8C15.4292 7.70823 15.4917 7.62823 15.5809 7.60597L18.3284 6.92L18.0777 5.4178C18.0375 5.17671 17.8286 5 17.5839 5H6.41613C6.17138 5 5.96251 5.17671 5.92227 5.4178L5.67157 6.92L8.41912 7.60597C8.50827 7.62823 8.57081 7.70823 8.57081 7.8C8.57081 7.91046 8.48115 8 8.37054 8H4.44243C4.18521 8 3.96984 8.19465 3.94425 8.45025Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M0.625739 15.5625L11.6116 11.0762C11.8602 10.9746 12.1397 10.9746 12.3883 11.0762L23.3741 15.5625C23.8914 15.7738 24.1369 16.3581 23.9224 16.8675C23.902 16.9161 23.8777 16.963 23.8497 17.0078L20.1855 22.8829C20.1265 22.9774 20.052 23.0616 19.9649 23.132C19.2494 23.7107 17.9463 24 16.0558 24C14.5348 24 13.2674 23.5007 11.9999 23.0013C10.7325 22.502 9.46505 22.0027 7.94412 22.0027C6.4927 22.0027 5.38756 22.1732 4.62868 22.5142C4.16291 22.7235 3.6118 22.558 3.34384 22.1284L0.150132 17.0078C-0.142979 16.5378 0.00622019 15.9228 0.483376 15.6341C0.528844 15.6066 0.576446 15.5827 0.625739 15.5625ZM15 17C15.5523 17 16 16.5523 16 16C16 15.4477 15.5523 15 15 15C14.4477 15 14 15.4477 14 16C14 16.5523 14.4477 17 15 17ZM10 16C10 16.5523 9.55229 17 9 17C8.44771 17 8 16.5523 8 16C8 15.4477 8.44771 15 9 15C9.55229 15 10 15.4477 10 16Z"
            fill={props.fill}
        />
    </svg>
);

BoatIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default BoatIcon;
