import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const BusIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M22 23.25V10.5L23.5854 9.95729C23.8395 9.83025 24 9.57055 24 9.28647V6C24 5.17157 22.8284 4.5 22 4.5V3.58187C22 2.28196 21.1628 1.12994 19.9265 0.728507C18.3839 0.227649 16.117 0 12 0C7.88299 0 5.54257 0.227649 4 0.728507C2.76363 1.12994 2 2.28196 2 3.58187V4.5C1.17157 4.5 0 5.17157 0 6V9.28647C0 9.57055 0.160502 9.83025 0.41459 9.95729L2 10.5V23.25C2 23.6642 2.33579 24 2.75 24H5.66442C6.00857 24 6.30856 23.7658 6.39202 23.4319L6.76729 21.9308L4.91056 21.3789C4.81176 21.3295 4.77172 21.2094 4.82111 21.1106C4.85499 21.0428 4.92425 21 5 21H19C19.0758 21 19.145 21.0428 19.1789 21.1106C19.2283 21.2094 19.1882 21.3295 19.0894 21.3789L17.2327 21.9308L17.608 23.4319C17.6914 23.7658 17.9914 24 18.3356 24H21.25C21.6642 24 22 23.6642 22 23.25ZM5 19C6.10457 19 7 18.1046 7 17C7 15.8954 6.10457 15 5 15C3.89543 15 3 15.8954 3 17C3 18.1046 3.89543 19 5 19ZM12 3C8.61907 3 6.05916 3.37835 4.32025 4.13506C3.79052 4.36564 3.43109 4.89532 3.39395 5.50018L3 11.9168C3 12.3084 3.26985 12.6414 3.63553 12.7011C4.85471 12.9004 7.64286 13 12 13C16.3571 13 19.1453 12.9004 20.3645 12.7012C20.7301 12.6414 21 12.3084 21 11.9168L20.606 5.50012C20.5689 4.89524 20.2094 4.36555 19.6797 4.13502C17.9407 3.37834 15.3809 3 12 3ZM21 17C21 18.1046 20.1046 19 19 19C17.8954 19 17 18.1046 17 17C17 15.8954 17.8954 15 19 15C20.1046 15 21 15.8954 21 17Z"
            fill={props.fill}
        />
    </svg>
);

BusIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default BusIcon;
