import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CloseForCircleBgIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M17.2071 8.20701C17.3892 8.01841 17.49 7.76581 17.4878 7.50361C17.4855 7.24141 17.3803 6.9906 17.1949 6.80519C17.0095 6.61978 16.7587 6.51461 16.4965 6.51234C16.2343 6.51006 15.9817 6.61085 15.7931 6.79301L12.0001 10.586L8.20708 6.79301C8.01848 6.61085 7.76588 6.51006 7.50368 6.51234C7.24148 6.51461 6.99067 6.61978 6.80526 6.80519C6.61985 6.9906 6.51469 7.24141 6.51241 7.50361C6.51013 7.76581 6.61092 8.01841 6.79308 8.20701L10.5861 12L6.79308 15.793C6.69757 15.8853 6.62139 15.9956 6.56898 16.1176C6.51657 16.2396 6.48898 16.3708 6.48783 16.5036C6.48668 16.6364 6.51198 16.7681 6.56226 16.891C6.61254 17.0139 6.68679 17.1255 6.78069 17.2194C6.87458 17.3133 6.98623 17.3876 7.10913 17.4378C7.23202 17.4881 7.3637 17.5134 7.49648 17.5123C7.62926 17.5111 7.76048 17.4835 7.88249 17.4311C8.00449 17.3787 8.11483 17.3025 8.20708 17.207L12.0001 13.414L15.7931 17.207C15.9817 17.3892 16.2343 17.49 16.4965 17.4877C16.7587 17.4854 17.0095 17.3802 17.1949 17.1948C17.3803 17.0094 17.4855 16.7586 17.4878 16.4964C17.49 16.2342 17.3892 15.9816 17.2071 15.793L13.4141 12L17.2071 8.20701Z"
            fill={props.fill}
        />
    </svg>
);

CloseForCircleBgIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default CloseForCircleBgIcon;
