import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CoffeeMachineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M22.4 1.33337H1.60001C1.45273 1.33337 1.33334 1.45276 1.33334 1.60004V5.06671C1.33334 5.21399 1.45273 5.33337 1.60001 5.33337H18.4C18.5473 5.33337 18.6667 5.45276 18.6667 5.60004V19.7334C18.6667 19.8807 18.5473 20 18.4 20H1.60001C1.45273 20 1.33334 20.1194 1.33334 20.2667V22.4C1.33334 22.5474 1.45273 22.6667 1.60001 22.6667H22.4C22.5473 22.6667 22.6667 22.5474 22.6667 22.4V1.60004C22.6667 1.45276 22.5473 1.33337 22.4 1.33337Z"
            fill={props.fill}
            stroke={props.fill}
        />
        <path
            d="M4.00002 2C4.00002 1.72386 3.70154 1.5 3.33335 1.5C2.96516 1.5 2.66669 1.72386 2.66669 2V4.5C2.66669 4.77614 2.96516 5 3.33335 5C3.70154 5 4.00002 4.77614 4.00002 4.5V2Z"
            fill="white"
        />
        <path
            d="M6.33333 2C6.33333 1.72386 6.03486 1.5 5.66667 1.5C5.29848 1.5 5 1.72386 5 2V4.5C5 4.77614 5.29848 5 5.66667 5C6.03486 5 6.33333 4.77614 6.33333 4.5V2Z"
            fill="white"
        />
        <path
            d="M5.33331 5.33331H14.6666C14.6666 6.80607 13.4728 7.99998 12 7.99998H7.99998C6.52722 7.99998 5.33331 6.80607 5.33331 5.33331Z"
            fill={props.fill}
        />
        <path
            d="M9 8.00002C9 7.26365 9.44772 6.66669 10 6.66669C10.5523 6.66669 11 7.26365 11 8.00002V8.33335C11 9.06973 10.5523 9.66669 10 9.66669C9.44772 9.66669 9 9.06973 9 8.33335V8.00002Z"
            fill={props.fill}
        />
    </svg>
);

CoffeeMachineIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default CoffeeMachineIcon;
