import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CopyIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M15 16.9999C15.5523 16.9999 16 17.4476 16 17.9998V19.5027C16 20.3312 15.3284 21.0027 14.5 21.0027H4.5C3.67157 21.0027 3 20.3312 3 19.5027V9.50275C3 8.67432 3.67157 8.00275 4.5 8.00275H6C6.55228 8.00275 7 8.45046 7 9.00275C7 9.55503 6.55228 10.0027 6 10.0027L5 10V19.0027H14V18.0027V17.9998C14 17.4476 14.4477 16.9999 15 16.9999Z"
            fill={props.fill}
        />
        <path
            d="M9 4.5C9 4.22386 9.22386 4 9.5 4H19.5C19.7761 4 20 4.22386 20 4.5V14.5C20 14.7761 19.7761 15 19.5 15H9.5C9.22386 15 9 14.7761 9 14.5V4.5Z"
            stroke={props.fill}
            strokeWidth={2}
        />
    </svg>
);

CopyIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default CopyIcon;
