import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CovidShildIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M12 2C9.42857 3.25 6.21429 4.67287 3 4.5L3.64286 13.043C3.64286 14.9229 4.61282 16.6846 6.24146 17.7627L12 22L17.7585 17.7627C19.3872 16.6846 20.3571 14.9229 20.3571 13.043L21 4.5C17.7857 4.67287 14.5714 3.25 12 2ZM15.9356 6.78063C15.7616 7.13703 15.3359 7.30865 14.8747 7.25048L13.7599 9.18148C14.0779 9.43708 14.3392 9.76043 14.5219 10.1296L16.3378 9.64307C16.6045 9.5716 16.8787 9.72989 16.9501 9.99663C17.0216 10.2634 16.8633 10.5375 16.5966 10.609L14.7978 11.091C14.8071 11.1844 14.8119 11.2791 14.8119 11.375C14.8119 11.654 14.7713 11.9235 14.6957 12.1779L16.6162 13.2867C16.9569 12.9986 17.3871 12.9089 17.7224 13.0962C18.1898 13.3572 18.2957 14.0574 17.9591 14.6601C17.6224 15.2629 16.9707 15.5398 16.5033 15.2788C16.1448 15.0785 15.9989 14.6198 16.1025 14.1448L14.243 13.0713C13.9722 13.4289 13.6178 13.7198 13.209 13.9149L13.9698 16.7542C14.0412 17.0209 13.8829 17.2951 13.6162 17.3666C13.3495 17.438 13.0753 17.2797 13.0038 17.013L12.2439 14.177C12.1634 14.184 12.0818 14.1875 11.9994 14.1875C11.6397 14.1875 11.2958 14.12 10.9797 13.9969L10.0051 15.6849C10.3038 16.0286 10.3986 16.4675 10.2076 16.8079C9.94568 17.2747 9.24527 17.3793 8.64321 17.0415C8.04116 16.7037 7.76544 16.0514 8.02738 15.5845C8.22538 15.2317 8.67389 15.0858 9.14109 15.1814L10.1271 13.4737C9.83436 13.2124 9.59667 12.8908 9.43351 12.5283L6.43842 13.3309C6.17169 13.4023 5.89752 13.244 5.82605 12.9773C5.75458 12.7106 5.91287 12.4364 6.1796 12.3649L9.19275 11.5576C9.18888 11.4972 9.18692 11.4363 9.18692 11.375C9.18692 10.9865 9.26569 10.6164 9.40812 10.2798L8.36186 9.67577C8.02376 9.96171 7.59721 10.0515 7.26291 9.86723C6.79412 9.6088 6.68428 8.90919 7.01757 8.30462C7.35086 7.70004 8.00108 7.41944 8.46987 7.67788C8.83152 7.87726 8.97955 8.33919 8.87529 8.8175L9.95663 9.44181C10.1984 9.18642 10.4876 8.97633 10.81 8.82563L10.3867 7.24579C10.3152 6.97906 10.4735 6.70489 10.7403 6.63342C11.007 6.56195 11.2812 6.72024 11.3526 6.98697L11.7771 8.57116C11.8505 8.56542 11.9246 8.5625 11.9994 8.5625C12.3074 8.5625 12.6038 8.612 12.8811 8.70348L13.9734 6.81162C13.6421 6.4835 13.5146 6.04106 13.689 5.6838C13.9239 5.20276 14.6172 5.05834 15.2376 5.36122C15.8579 5.6641 16.1704 6.29959 15.9356 6.78063Z"
            fill={props.fill}
        />
    </svg>
);

CovidShildIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default CovidShildIcon;
