import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DeleteIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M12.663 1.5H11.337C10.268 1.5 9.847 1.59 9.416 1.77C8.984 1.951 8.624 2.223 8.332 2.59C8.04 2.955 7.839 3.336 7.548 4.364L7.368 5H5C4.73478 5 4.48043 5.10536 4.29289 5.29289C4.10536 5.48043 4 5.73478 4 6C4 6.26522 4.10536 6.51957 4.29289 6.70711C4.48043 6.89464 4.73478 7 5 7H5.563L6.266 18.25C6.348 19.57 6.389 20.23 6.673 20.731C6.9226 21.1719 7.30029 21.5266 7.756 21.748C8.273 22 8.935 22 10.258 22H13.742C15.065 22 15.727 22 16.244 21.748C16.6997 21.5266 17.0774 21.1719 17.327 20.731C17.611 20.231 17.652 19.571 17.734 18.249L18.437 7H19C19.2652 7 19.5196 6.89464 19.7071 6.70711C19.8946 6.51957 20 6.26522 20 6C20 5.73478 19.8946 5.48043 19.7071 5.29289C19.5196 5.10536 19.2652 5 19 5H16.633L16.453 4.364C16.161 3.336 15.96 2.955 15.668 2.589C15.3826 2.22788 15.0094 1.94591 14.584 1.77C14.153 1.59 13.732 1.5 12.664 1.5H12.663ZM14.553 5L14.528 4.91C14.325 4.193 14.238 4.005 14.104 3.836C14.0281 3.73759 13.9273 3.66128 13.812 3.615C13.612 3.531 13.408 3.5 12.663 3.5H11.337C10.592 3.5 10.387 3.531 10.188 3.615C10.0727 3.66128 9.97186 3.73759 9.896 3.836C9.761 4.005 9.675 4.193 9.472 4.91L9.446 5H14.554H14.553ZM9.61 8.506C9.51149 8.50936 9.41461 8.5321 9.32489 8.57292C9.23518 8.61375 9.15439 8.67186 9.08715 8.74393C9.01991 8.816 8.96753 8.90062 8.93302 8.99294C8.8985 9.08527 8.88253 9.18349 8.886 9.282L9.183 17.777C9.1918 17.9745 9.27824 18.1606 9.42352 18.2947C9.5688 18.4288 9.76116 18.5001 9.95876 18.4931C10.1564 18.4862 10.3432 18.4014 10.4786 18.2574C10.6141 18.1133 10.6872 17.9217 10.682 17.724L10.385 9.23C10.3782 9.03123 10.2928 8.84328 10.1474 8.70751C10.0021 8.57174 9.80877 8.49925 9.61 8.506ZM13.618 9.23C13.6271 9.03278 13.7136 8.84711 13.8587 8.71327C14.0039 8.57942 14.1959 8.50819 14.3932 8.51503C14.5905 8.52188 14.7772 8.60624 14.9127 8.74983C15.0482 8.89341 15.1216 9.08463 15.117 9.282L14.82 17.777C14.8112 17.9745 14.7248 18.1606 14.5795 18.2947C14.4342 18.4288 14.2418 18.5001 14.0442 18.4931C13.8466 18.4862 13.6598 18.4014 13.5244 18.2574C13.3889 18.1133 13.3158 17.9217 13.321 17.724L13.618 9.23Z"
            fill={props.fill}
        />
    </svg>
);

DeleteIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default DeleteIcon;
