import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DisabledIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M8.99999 5C10.1046 5 11 4.10457 11 3C11 1.89543 10.1046 1 8.99999 1C7.89542 1 6.99999 1.89543 6.99999 3C6.99999 4.10457 7.89542 5 8.99999 5Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6.25192 13.5986L6.86167 14.9811C7.00619 15.3088 6.87302 15.6924 6.55656 15.8601C6.2551 16.0198 5.88201 15.9326 5.68264 15.6557L2.91192 11.8082C2.90051 11.7924 2.89659 11.7744 2.90273 11.7558C3.01368 11.4213 4.13918 8.09074 5.35047 6.92371C6.62642 5.69438 8.98486 4.85312 9.96227 6.53485C10.6248 7.67475 10.998 9.75449 11.1697 10.9763C10.5976 10.8571 9.98963 10.8823 9.4014 11.0756C9.87509 11.0861 10.3408 11.1531 10.7899 11.2715C11.8617 11.5541 12.8392 12.1299 13.6061 12.9319C13.3671 12.3997 13.0073 11.9564 12.5727 11.6214H16.4532C16.4851 11.6214 16.513 11.6429 16.5211 11.6737L18.0947 17.659C18.2071 18.0864 17.9529 18.5243 17.5261 18.6387C17.1335 18.7438 16.7243 18.5391 16.5731 18.1619L14.957 14.1308C14.9543 14.1241 14.948 14.1198 14.9407 14.1201C14.8936 14.1222 14.7099 14.1301 14.4957 14.133C14.7363 14.5614 14.9278 15.0264 15.0608 15.5227C15.7761 18.1924 14.5733 20.9243 12.2971 22.2549C13.4324 22.082 14.4675 21.3872 15.0341 20.3046L20.7324 18.7739C20.8674 18.7376 21 18.8393 21 18.979V23.8416C21 23.9291 20.9291 24 20.8416 24H5.56598C5.25339 24 4.99999 23.7466 4.99999 23.434C4.99999 23.178 5.17188 22.9538 5.41915 22.8874L6.75928 22.5274C5.19472 21.8072 3.95026 20.4222 3.46964 18.6285C3.086 17.2935 3.38287 15.8852 3.53256 15.3287C3.56647 15.2026 3.71176 15.1516 3.82094 15.2232L4.69975 15.7998C4.77276 15.8477 4.80677 15.937 4.78824 16.0223C4.71241 16.3715 4.55681 17.3131 4.82194 18.2662C5.47947 20.7201 8.00182 22.1764 10.4558 21.5189C12.9097 20.8613 14.366 18.339 13.7085 15.885C13.0509 13.4311 10.5286 11.9748 8.07463 12.6323C7.3782 12.8189 6.76213 13.1558 6.25192 13.5986ZM5.66697 12.2723C6.07568 11.9659 6.52848 11.7086 7.01901 11.5113C6.86735 11.1278 6.67828 10.6619 6.5386 10.3579C6.26493 9.76239 6.03052 9.46169 6.03052 9.46169C6.03052 9.46169 5.77422 10.0801 5.65829 10.3579C5.54769 10.623 5.24933 11.2024 5.22208 11.2552C5.22068 11.2579 5.2208 11.2607 5.22203 11.2635L5.66697 12.2723Z"
            fill={props.fill}
        />
    </svg>
);

DisabledIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default DisabledIcon;
