import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const DownChartsIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <circle cx={12} cy={12} r={10} fill={props.fill} />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M9.78702 11.7044L13.5125 9.52394L13.5137 9.52324C13.6918 9.42064 13.8977 9.39458 14.0922 9.44798C14.2889 9.50201 14.4547 9.62926 14.5528 9.8112L14.5586 9.8219L16.4677 14.6979L17.1456 12.2291C17.2578 11.8206 17.6751 11.573 18.0817 11.6847C18.4892 11.7966 18.7194 12.2269 18.6085 12.6308L17.398 17.0391C17.2855 17.4489 16.8681 17.6936 16.4597 17.5869L16.4573 17.5863L12.1487 16.4031C11.7412 16.2912 11.511 15.8609 11.6219 15.457C11.7341 15.0485 12.1514 14.8009 12.558 14.9125L15.1688 15.6295L13.5654 11.2621L9.8459 13.4391L9.8447 13.4398C9.66658 13.5424 9.46068 13.5684 9.2662 13.515C9.06746 13.4605 8.90765 13.3334 8.80726 13.1549L8.80142 13.1445L6.69497 8.06701C6.62918 7.94046 6.57352 7.74181 6.64314 7.48827C6.69669 7.29329 6.81293 7.13052 6.99053 7.02833M9.78702 11.7044L8.03443 7.3247L8.02798 7.31322C7.92758 7.13467 7.76777 7.00765 7.56903 6.95308C7.37459 6.89968 7.16863 6.92579 6.99053 7.02833"
            fill="white"
        />
    </svg>
);

DownChartsIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default DownChartsIcon;
