import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const EntertainmentIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 26"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M19.917 9.45301H4.08295C2.99937 9.45507 1.96088 9.88697 1.1954 10.6539C0.429917 11.4208 -1.95821e-06 12.4602 0 13.5437V19.7265C0.0964622 20.7897 0.586985 21.7783 1.3752 22.4983C2.16342 23.2182 3.19236 23.6174 4.25988 23.6174C5.3274 23.6174 6.35634 23.2182 7.14456 22.4983C7.93278 21.7783 8.4233 20.7897 8.51977 19.7265V18.3461C8.51977 18.2945 8.54025 18.2451 8.57671 18.2086C8.61318 18.1721 8.66263 18.1517 8.71419 18.1517H15.2858C15.3374 18.1517 15.3868 18.1721 15.4233 18.2086C15.4597 18.2451 15.4802 18.2945 15.4802 18.3461V19.7187C15.5767 20.7819 16.0672 21.7705 16.8554 22.4905C17.6437 23.2104 18.6726 23.6096 19.7401 23.6096C20.8076 23.6096 21.8366 23.2104 22.6248 22.4905C23.413 21.7705 23.9035 20.7819 24 19.7187V13.5437C24 12.4602 23.5701 11.4208 22.8046 10.6539C22.0391 9.88697 21.0006 9.45507 19.917 9.45301ZM4.58846 16.3474C4.15761 16.3474 3.73645 16.2196 3.37826 15.9801C3.02008 15.7407 2.74098 15.4003 2.57628 15.0022C2.41158 14.6041 2.36868 14.1661 2.45302 13.7435C2.53736 13.321 2.74514 12.933 3.05007 12.6286C3.35499 12.3243 3.74336 12.1172 4.16603 12.0336C4.58869 11.95 5.02665 11.9937 5.42448 12.1591C5.82232 12.3245 6.16214 12.6042 6.40094 12.9628C6.63975 13.3214 6.76681 13.7428 6.76604 14.1737C6.76501 14.7505 6.53513 15.3034 6.12687 15.711C5.71861 16.1185 5.16532 16.3474 4.58846 16.3474ZM21.0058 14.757H19.9948V15.7641C19.9948 15.9188 19.9334 16.0672 19.824 16.1765C19.7146 16.2859 19.5662 16.3474 19.4115 16.3474C19.2568 16.3474 19.1085 16.2859 18.9991 16.1765C18.8897 16.0672 18.8283 15.9188 18.8283 15.7641V14.757H17.8328C17.6781 14.757 17.5297 14.6955 17.4204 14.5861C17.311 14.4767 17.2495 14.3284 17.2495 14.1737C17.2495 14.019 17.311 13.8706 17.4204 13.7612C17.5297 13.6519 17.6781 13.5904 17.8328 13.5904H18.8438V12.5794C18.8438 12.4247 18.9053 12.2763 19.0146 12.167C19.124 12.0576 19.2724 11.9961 19.4271 11.9961C19.5818 11.9961 19.7301 12.0576 19.8395 12.167C19.9489 12.2763 20.0104 12.4247 20.0104 12.5794V13.5904H21.0214C21.1761 13.5904 21.3244 13.6519 21.4338 13.7612C21.5432 13.8706 21.6047 14.019 21.6047 14.1737C21.6047 14.3284 21.5432 14.4767 21.4338 14.5861C21.3244 14.6955 21.1761 14.757 21.0214 14.757H21.0058ZM5.59948 14.1737C5.59948 14.3736 5.54019 14.5691 5.42909 14.7354C5.318 14.9016 5.1601 15.0312 4.97536 15.1077C4.79062 15.1843 4.58734 15.2043 4.39122 15.1653C4.19511 15.1263 4.01496 15.03 3.87357 14.8886C3.73217 14.7472 3.63588 14.567 3.59687 14.3709C3.55786 14.1748 3.57788 13.9715 3.65441 13.7868C3.73093 13.602 3.86051 13.4442 4.02677 13.3331C4.19303 13.222 4.3885 13.1627 4.58846 13.1627C4.8566 13.1627 5.11376 13.2692 5.30336 13.4588C5.49296 13.6484 5.59948 13.9056 5.59948 14.1737ZM12.5988 8.28646H11.4323V6.4394C11.4333 5.76937 11.6999 5.12708 12.1737 4.6533C12.6475 4.17951 13.2898 3.91289 13.9598 3.91186H16.0557C16.4167 3.91186 16.7629 3.76847 17.0181 3.51324C17.2733 3.258 17.4167 2.91183 17.4167 2.55087V0.583279C17.4167 0.428584 17.4782 0.280225 17.5876 0.170839C17.6969 0.0614525 17.8453 0 18 0C18.1547 0 18.3031 0.0614525 18.4124 0.170839C18.5218 0.280225 18.5833 0.428584 18.5833 0.583279V2.55087C18.5833 2.8828 18.5179 3.21147 18.3909 3.51812C18.2639 3.82478 18.0777 4.10341 17.843 4.33812C17.6083 4.57282 17.3296 4.759 17.023 4.88602C16.7163 5.01304 16.3877 5.07842 16.0557 5.07842H13.9443C13.5836 5.07944 13.238 5.22316 12.983 5.47818C12.728 5.73319 12.5843 6.07876 12.5833 6.4394L12.5988 8.28646Z"
            fill={props.fill}
        />
    </svg>
);

EntertainmentIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default EntertainmentIcon;
