import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ExternalAreaIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M6.18164 0.0441349C6.26153 0.0845033 6.3263 0.149969 6.36625 0.230706L10.9563 9.50854C11.0583 9.71462 10.9756 9.96521 10.7717 10.0683C10.7615 10.0734 10.751 10.0782 10.7404 10.0825L6.37182 11.8485C6.13141 11.9457 5.86265 11.9457 5.62224 11.8485L1.25364 10.0825C1.04197 9.99689 0.939013 9.7541 1.03774 9.50854L5.62782 0.230706C5.72978 0.0246252 5.97773 -0.0589056 6.18164 0.0441349Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M12.0319 8.97642C12.4252 9.77146 12.1063 10.7384 11.3129 11.1393C11.2524 11.1688 11.2523 11.1688 11.1902 11.195L11.0248 11.2619L13 16.1306V14H15V17H13.3337C13.4389 17.4047 13.4166 17.8272 13.2818 18.209C13.1184 18.6719 12.7894 19.0748 12.3213 19.3132C12.1455 19.4027 11.9569 19.4645 11.7618 19.4957L11 19.6178V22H7.16667L7.10806 20.2417L6.00907 20.4178L4.89202 20.2393L4.83333 22H3.2C3.08954 22 3 22.0895 3 22.2V22.8C3 22.9105 3.08954 23 3.2 23H23.8C23.9105 23 24 22.9105 24 22.8V22.2C24 22.0895 23.9105 22 23.8 22H23V9H23.5C23.7761 9 24 8.77614 24 8.5V6.5C24 6.22386 23.7761 6 23.5 6H10.5594L12.0319 8.97642ZM15 20H19V22H15V20ZM15 9H13V12H15V9ZM16 9H18V12H16V9ZM21 9H19V12H21V9ZM18 14H16V17H18V14ZM19 14H21V17H19V14Z"
            fill={props.fill}
        />
        <path
            d="M0.048068 17.2708L2.27219 11.7886L5.1725 12.961C5.7014 13.1748 6.29267 13.1748 6.82157 12.961L9.72682 11.7866L11.9519 17.2711C12.0743 17.5728 11.9552 17.9285 11.686 18.0656C11.6396 18.0892 11.5906 18.1053 11.5402 18.1134L6.00876 19L0.459953 18.1131C0.167162 18.0663 -0.0363329 17.7624 0.00543526 17.4344C0.0126303 17.3779 0.0269859 17.3228 0.048068 17.2708Z"
            fill={props.fill}
        />
    </svg>
);

ExternalAreaIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default ExternalAreaIcon;
