import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const GiftIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M20.4 8H18.8169C20.0082 6.78827 20.3684 5.02639 19.5811 3.65071C18.6121 1.95735 15.8978 1.49038 13.9796 2.60771C13.2074 3.05756 12.4954 3.7647 11.9837 4.55955C11.472 3.7647 10.7601 3.05756 9.98778 2.60771C8.0696 1.49038 5.38791 1.95735 4.41887 3.65071C3.63163 5.02639 3.99177 6.78827 5.18309 8H3.6C3.03995 8 2.75992 8 2.54601 8.10899C2.35785 8.20487 2.20487 8.35785 2.10899 8.54601C2 8.75992 2 9.03995 2 9.6V10.4C2 10.9601 2 11.2401 2.10899 11.454C2.20487 11.6422 2.35785 11.7951 2.54601 11.891C2.75992 12 3.03964 12 3.59907 12H20.4009C20.9604 12 21.2401 12 21.454 11.891C21.6422 11.7951 21.7951 11.6422 21.891 11.454C22 11.2401 22 10.9601 22 10.4V9.6C22 9.03995 22 8.75992 21.891 8.54601C21.7951 8.35785 21.6422 8.20487 21.454 8.10899C21.2401 8 20.9601 8 20.4 8ZM13.5519 6.88602L13.5503 6.88315C13.5235 6.83644 13.5153 6.82211 13.5413 6.83067C13.5411 6.85452 13.5446 6.8732 13.5519 6.88602ZM13.5413 6.83067C13.544 6.51654 14.1889 5.30448 15.1651 4.73587C16.032 4.23095 17.2664 4.45509 17.5139 4.8877C17.7681 5.33176 17.4971 6.13407 16.677 6.61175C16.1606 6.91257 15.2794 7.09516 14.4735 7.04145C14.1069 7.01702 13.7989 6.94643 13.5939 6.85317C13.5694 6.84204 13.5523 6.8343 13.5413 6.83067ZM6.48606 4.8877C6.73514 4.45244 7.93785 4.23233 8.8023 4.73587C9.78081 5.30584 10.4265 6.52234 10.4261 6.83291C10.4154 6.83639 10.3983 6.84415 10.3736 6.85547C10.1725 6.94752 9.86997 7.01731 9.5092 7.04152C8.71321 7.09492 7.84043 6.91318 7.32295 6.61175C6.50288 6.13407 6.23195 5.33176 6.48606 4.8877ZM10.417 6.88342C10.4424 6.83907 10.4504 6.82507 10.4261 6.83291C10.4261 6.85569 10.4226 6.8736 10.4155 6.88602L10.417 6.88342Z"
            fill={props.fill}
        />
        <path
            d="M3 13H10V16.2275C10 16.4698 10 16.5909 10.0479 16.647C10.0895 16.6957 10.1519 16.7216 10.2157 16.7165C10.2892 16.7108 10.3749 16.6251 10.5463 16.4537L11.7737 15.2263C11.8529 15.1471 11.8925 15.1075 11.9382 15.0926C11.9784 15.0796 12.0216 15.0796 12.0618 15.0926C12.1075 15.1075 12.1471 15.1471 12.2263 15.2263L13.4537 16.4537C13.6251 16.6251 13.7108 16.7108 13.7843 16.7165C13.8481 16.7216 13.9105 16.6957 13.9521 16.647C14 16.5909 14 16.4698 14 16.2275V13H21V19C21 20.1046 20.1046 21 19 21H5C3.89543 21 3 20.1046 3 19V13Z"
            fill={props.fill}
        />
    </svg>
);

GiftIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default GiftIcon;
