import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HandLuggageIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M16.9 8.15137H7.1V20.001H16.9V8.15137ZM18.1 19.9998C20.2629 19.9467 22 18.1767 22 16.001L22 12.1514C22 9.97566 20.2629 8.20566 18.1 8.15259V19.9998ZM2.00001 12.1514C2.00001 9.97566 3.73708 8.20567 5.9 8.15259V19.9998C3.73707 19.9467 2 18.1767 2 16.001L2.00001 12.1514Z"
            fill={props.fill}
        />
        <path
            d="M8.50386 6.77629L8.49671 6.88298H8.60364H9.35194H9.44349L9.45155 6.79178C9.5577 5.5907 10.6002 4.894 11.8962 4.894C13.1917 4.894 14.2356 5.59061 14.3596 6.79324L14.3689 6.88298H14.4591H15.2074H15.3155L15.3071 6.77519C15.2393 5.90783 14.8311 5.23633 14.2143 4.78375C13.5996 4.3327 12.7824 4.10209 11.8962 4.10209C11.01 4.10209 10.1927 4.33268 9.58026 4.78386C8.96561 5.23666 8.56201 5.90856 8.50386 6.77629Z"
            fill={props.fill}
            stroke={props.fill}
            strokeWidth={0.2}
        />
    </svg>
);

HandLuggageIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default HandLuggageIcon;
