import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HandLuggageSizeIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M6.00001 8.15137C3.79087 8.15137 2.00001 9.94222 2.00001 12.1514L2 16.001C1.99999 18.2101 3.79086 20.001 6 20.001H18C20.2091 20.001 22 18.2101 22 16.001L22 12.1514C22 9.94223 20.2092 8.15137 18 8.15137H6.00001ZM13.8233 16.9533H14.8853V10.5003H13.9673L12.4733 11.9763V13.0563L13.8233 11.7333V16.9533ZM8.52611 16.9533L9.66011 15.2343L10.8031 16.9533H11.9911L10.3891 14.5413L11.9011 12.2823H10.8751L9.87611 13.8213L8.85011 12.2823H7.66211L9.14711 14.5233L7.50011 16.9533H8.52611Z"
            fill={props.fill}
        />
        <path
            d="M8.50386 6.77629L8.49671 6.88298H8.60364H9.35194H9.44349L9.45155 6.79178C9.5577 5.5907 10.6002 4.894 11.8962 4.894C13.1917 4.894 14.2356 5.59061 14.3596 6.79324L14.3689 6.88298H14.4591H15.2074H15.3155L15.3071 6.77519C15.2393 5.90783 14.8311 5.23633 14.2143 4.78375C13.5996 4.3327 12.7824 4.10209 11.8962 4.10209C11.01 4.10209 10.1927 4.33268 9.58026 4.78386C8.96561 5.23666 8.56201 5.90856 8.50386 6.77629Z"
            fill={props.fill}
            stroke={props.fill}
            strokeWidth={0.2}
        />
    </svg>
);

HandLuggageSizeIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default HandLuggageSizeIcon;
