import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HotelIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M7.5 13.99C8.88071 13.99 10 12.8718 10 11.4925C10 10.1132 8.88071 8.995 7.5 8.995C6.11929 8.995 5 10.1132 5 11.4925C5 12.8718 6.11929 13.99 7.5 13.99Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M4 18.5L2.7355 21.2126C2.58684 21.5192 2.51477 21.6199 2.41735 21.718C2.31993 21.8161 2.20931 21.8866 2.08064 21.9326C1.95197 21.9786 1.8324 22 1.5 22H0V6H0.962192C1.34692 6 1.48667 6.03245 1.63294 6.09753C1.7792 6.16262 1.90057 6.26034 1.99727 6.39089C2.09397 6.52143 2.1584 6.65338 2.25171 7.03828L3.55066 14.1465C3.67239 14.6486 3.81205 14.9571 4.00546 15.2182C4.19886 15.4793 4.4416 15.6748 4.73413 15.8049C5.02665 15.9351 5.35075 16 5.85266 16H5.92633H6C9.60516 16 19.7783 16 23.005 16C23.5573 16 24 16.4477 24 17V22H22.5C22.1676 22 22.048 21.9786 21.9194 21.9326C21.7907 21.8866 21.6801 21.8161 21.5827 21.718C21.4852 21.6199 21.4132 21.5192 21.2645 21.2126L20 18.5H4Z"
            fill={props.fill}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M11.7673 15C11.1197 15 10.647 14.3938 10.7995 13.7644L11 12.9375C11.5647 10.608 13.7702 9.11677 16.067 9.51153L20.5408 10.3664C22.2484 10.6599 23.5 12.1835 23.5 13.9688V14C23.5 14.5523 23.0549 15 22.5026 15C19.2053 15 14.116 15 11.7673 15Z"
            fill={props.fill}
        />
    </svg>
);

HotelIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default HotelIcon;
