import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const InternetAndTelephonyIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M18.2471 3.79645C16.1647 3.26548 14.0824 3 12 3C10.3333 3 8.66667 3.17007 7 3.5102V1C7 0.447715 6.55228 0 6 0C5.44772 0 5 0.447715 5 1V17C5 20.866 8.13401 24 12 24C15.866 24 19 20.866 19 17V4.76545C19 4.30833 18.69 3.9094 18.2471 3.79645ZM7.10899 6.54601C7 6.75992 7 7.03995 7 7.6V11.4C7 11.9601 7 12.2401 7.10899 12.454C7.20487 12.6422 7.35785 12.7951 7.54601 12.891C7.75992 13 8.03995 13 8.6 13H15.4C15.9601 13 16.2401 13 16.454 12.891C16.6422 12.7951 16.7951 12.6422 16.891 12.454C17 12.2401 17 11.9601 17 11.4V7.6C17 7.03995 17 6.75992 16.891 6.54601C16.7951 6.35785 16.6422 6.20487 16.454 6.10899C16.2401 6 15.9601 6 15.4 6H8.6C8.03995 6 7.75992 6 7.54601 6.10899C7.35785 6.20487 7.20487 6.35785 7.10899 6.54601ZM8.64097 15H9.35903C9.58191 15 9.66273 15.0232 9.74421 15.0668C9.82569 15.1104 9.88964 15.1743 9.93322 15.2558C9.97679 15.3373 10 15.4181 10 15.641V16.359C10 16.5819 9.97679 16.6627 9.93322 16.7442C9.88964 16.8257 9.82569 16.8896 9.74421 16.9332C9.66273 16.9768 9.58191 17 9.35903 17H8.64097C8.41809 17 8.33727 16.9768 8.25579 16.9332C8.17431 16.8896 8.11036 16.8257 8.06678 16.7442C8.02321 16.6627 8 16.5819 8 16.359V15.641C8 15.4181 8.02321 15.3373 8.06678 15.2558C8.11036 15.1743 8.17431 15.1104 8.25579 15.0668C8.33727 15.0232 8.41809 15 8.64097 15ZM12.7442 15.0668C12.6627 15.0232 12.5819 15 12.359 15H11.641C11.4181 15 11.3373 15.0232 11.2558 15.0668C11.1743 15.1104 11.1104 15.1743 11.0668 15.2558C11.0232 15.3373 11 15.4181 11 15.641V16.359C11 16.5819 11.0232 16.6627 11.0668 16.7442C11.1104 16.8257 11.1743 16.8896 11.2558 16.9332C11.3373 16.9768 11.4181 17 11.641 17H12.359C12.5819 17 12.6627 16.9768 12.7442 16.9332C12.8257 16.8896 12.8896 16.8257 12.9332 16.7442C12.9768 16.6627 13 16.5819 13 16.359V15.641C13 15.4181 12.9768 15.3373 12.9332 15.2558C12.8896 15.1743 12.8257 15.1104 12.7442 15.0668ZM8.64097 18H9.35903C9.58191 18 9.66273 18.0232 9.74421 18.0668C9.82569 18.1104 9.88964 18.1743 9.93322 18.2558C9.97679 18.3373 10 18.4181 10 18.641V19.359C10 19.5819 9.97679 19.6627 9.93322 19.7442C9.88964 19.8257 9.82569 19.8896 9.74421 19.9332C9.66273 19.9768 9.58191 20 9.35903 20H9C8.44772 20 8 19.5523 8 19V18.641C8 18.4181 8.02321 18.3373 8.06678 18.2558C8.11036 18.1743 8.17431 18.1104 8.25579 18.0668C8.33727 18.0232 8.41809 18 8.64097 18ZM12.7442 18.0668C12.6627 18.0232 12.5819 18 12.359 18H11.641C11.4181 18 11.3373 18.0232 11.2558 18.0668C11.1743 18.1104 11.1104 18.1743 11.0668 18.2558C11.0232 18.3373 11 18.4181 11 18.641V19.359C11 19.5819 11.0232 19.6627 11.0668 19.7442C11.1104 19.8257 11.1743 19.8896 11.2558 19.9332C11.3373 19.9768 11.4181 20 11.641 20H12.359C12.5819 20 12.6627 19.9768 12.7442 19.9332C12.8257 19.8896 12.8896 19.8257 12.9332 19.7442C12.9768 19.6627 13 19.5819 13 19.359V18.641C13 18.4181 12.9768 18.3373 12.9332 18.2558C12.8896 18.1743 12.8257 18.1104 12.7442 18.0668ZM14.641 15H15.359C15.5819 15 15.6627 15.0232 15.7442 15.0668C15.8257 15.1104 15.8896 15.1743 15.9332 15.2558C15.9768 15.3373 16 15.4181 16 15.641V16.359C16 16.5819 15.9768 16.6627 15.9332 16.7442C15.8896 16.8257 15.8257 16.8896 15.7442 16.9332C15.6627 16.9768 15.5819 17 15.359 17H14.641C14.4181 17 14.3373 16.9768 14.2558 16.9332C14.1743 16.8896 14.1104 16.8257 14.0668 16.7442C14.0232 16.6627 14 16.5819 14 16.359V15.641C14 15.4181 14.0232 15.3373 14.0668 15.2558C14.1104 15.1743 14.1743 15.1104 14.2558 15.0668C14.3373 15.0232 14.4181 15 14.641 15ZM15.359 18H14.641C14.4181 18 14.3373 18.0232 14.2558 18.0668C14.1743 18.1104 14.1104 18.1743 14.0668 18.2558C14.0232 18.3373 14 18.4181 14 18.641V19.359C14 19.5819 14.0232 19.6627 14.0668 19.7442C14.1104 19.8257 14.1743 19.8896 14.2558 19.9332C14.3373 19.9768 14.4181 20 14.641 20H15C15.5523 20 16 19.5523 16 19V18.641C16 18.4181 15.9768 18.3373 15.9332 18.2558C15.8896 18.1743 15.8257 18.1104 15.7442 18.0668C15.6627 18.0232 15.5819 18 15.359 18Z"
            fill={props.fill}
        />
    </svg>
);

InternetAndTelephonyIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default InternetAndTelephonyIcon;
