import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const KitchenIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <rect width={24} height={24} fill="white" />
        <path
            d="M19 3H23C23.5523 3 24 3.44772 24 4V18C24 18.5523 23.5523 19 23 19H19V3Z"
            fill={props.fill}
        />
        <rect y={3} width={18} height={16} rx={1} fill={props.fill} />
        <path
            d="M3 19H6V20.5C6 20.7761 5.77614 21 5.5 21H3.5C3.22386 21 3 20.7761 3 20.5V19Z"
            fill={props.fill}
        />
        <path
            d="M19 19H22V20.5C22 20.7761 21.7761 21 21.5 21H19.5C19.2239 21 19 20.7761 19 20.5V19Z"
            fill={props.fill}
        />
        <rect
            x={10.4853}
            y={5}
            width={2}
            height={12}
            rx={1}
            transform="rotate(45 10.4853 5)"
            fill="white"
        />
        <rect
            x={14.6569}
            y={6}
            width={2}
            height={8}
            rx={1}
            transform="rotate(45 14.6569 6)"
            fill="white"
        />
        <circle cx={21.5} cy={7.5} r={1.5} fill="white" />
        <rect x={20} y={14} width={3} height={3} rx={1} fill="white" />
        <rect x={20} y={10} width={1} height={1} rx={0.2} fill="white" />
        <rect x={22} y={10} width={1} height={1} rx={0.2} fill="white" />
        <rect x={22} y={12} width={1} height={1} rx={0.2} fill="white" />
        <rect x={20} y={12} width={1} height={1} rx={0.2} fill="white" />
    </svg>
);

KitchenIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default KitchenIcon;
