import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ListIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M5 3C5 2.44772 5.44772 2 6 2H18C18.5523 2 19 2.44772 19 3C19 3.55228 18.5523 4 18 4H6C5.44772 4 5 3.55228 5 3ZM15.7951 6H8.20486C7.09046 6 6.68635 6.11603 6.27894 6.33392C5.87154 6.5518 5.5518 6.87154 5.33392 7.27894C5.11603 7.68635 5 8.09046 5 9.20486V14.7951C5 15.9095 5.11603 16.3136 5.33392 16.7211C5.5518 17.1285 5.87154 17.4482 6.27894 17.6661C6.68635 17.884 7.09046 18 8.20486 18H15.7951C16.9095 18 17.3136 17.884 17.7211 17.6661C18.1285 17.4482 18.4482 17.1285 18.6661 16.7211C18.884 16.3136 19 15.9095 19 14.7951V9.20486C19 8.09046 18.884 7.68635 18.6661 7.27894C18.4482 6.87154 18.1285 6.5518 17.7211 6.33392C17.3136 6.11603 16.9095 6 15.7951 6ZM7.35599 8.04897C7.51125 8.01899 7.77844 8 8.20486 8H15.7951C16.2216 8 16.4887 8.01899 16.644 8.04897C16.7048 8.06072 16.7183 8.06567 16.7779 8.09754C16.8367 8.12903 16.871 8.16327 16.9025 8.22214C16.9343 8.28173 16.9393 8.29517 16.951 8.35599C16.981 8.51125 17 8.77844 17 9.20486V14.7951C17 15.2216 16.981 15.4887 16.951 15.644C16.9393 15.7048 16.9343 15.7183 16.9025 15.7779C16.871 15.8367 16.8367 15.871 16.7779 15.9025C16.7183 15.9343 16.7048 15.9393 16.644 15.951C16.4887 15.981 16.2216 16 15.7951 16H8.20486C7.77844 16 7.51125 15.981 7.35599 15.951C7.29517 15.9393 7.28173 15.9343 7.22214 15.9025C7.16327 15.871 7.12903 15.8367 7.09754 15.7779C7.06567 15.7183 7.06072 15.7048 7.04897 15.644C7.01899 15.4887 7 15.2216 7 14.7951V9.20486C7 8.77844 7.01899 8.51125 7.04897 8.35599C7.06072 8.29517 7.06567 8.28173 7.09754 8.22214C7.12903 8.16327 7.16327 8.12903 7.22214 8.09754C7.28173 8.06567 7.29517 8.06072 7.35599 8.04897ZM6 20C5.44772 20 5 20.4477 5 21C5 21.5523 5.44772 22 6 22H18C18.5523 22 19 21.5523 19 21C19 20.4477 18.5523 20 18 20H6Z"
            fill={props.fill}
        />
    </svg>
);

ListIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default ListIcon;
