import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const MailIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M5.205 5H18.795C19.909 5 20.314 5.116 20.721 5.334C21.128 5.552 21.448 5.872 21.666 6.279C21.884 6.686 22 7.09 22 8.205V15.795C22 16.91 21.884 17.314 21.666 17.721C21.4529 18.1236 21.1236 18.4529 20.721 18.666C20.314 18.884 19.91 19 18.795 19H5.205C4.09 19 3.686 18.884 3.279 18.666C2.87638 18.4529 2.54714 18.1236 2.334 17.721C2.116 17.314 2 16.91 2 15.795V8.205C2 7.09 2.116 6.686 2.334 6.279C2.552 5.872 2.872 5.552 3.279 5.334C3.686 5.116 4.09 5 5.205 5ZM4 9.5L3.855 7.763L3.939 7.707L4.998 8.63L10.56 12.549C10.9815 12.846 11.4844 13.0054 12 13.0054C12.5156 13.0054 13.0185 12.846 13.44 12.549L18.998 8.634L20.06 7.707L20.145 7.763L20 9.5V15.795C20 16.222 19.981 16.489 19.951 16.644C19.944 16.6915 19.9273 16.7371 19.902 16.778C19.8755 16.8321 19.8319 16.876 19.778 16.903C19.7371 16.9279 19.6915 16.9443 19.644 16.951C19.489 16.981 19.222 17 18.795 17H5.205C4.778 17 4.511 16.981 4.356 16.951C4.30846 16.944 4.26287 16.9273 4.222 16.902C4.16824 16.8753 4.12469 16.8318 4.098 16.778C4.07272 16.7371 4.05604 16.6915 4.049 16.644C4.019 16.489 4 16.222 4 15.795V9.5ZM18.55 6.7L16 7H8L5.45 6.7L5.347 6.769C6.07829 7.05931 6.77276 7.4349 7.416 7.888L11.712 10.914C11.7963 10.9734 11.8969 11.0053 12 11.0053C12.1031 11.0053 12.2037 10.9734 12.288 10.914L16.58 7.89C17.2244 7.43627 17.9203 7.06033 18.653 6.77L18.55 6.7Z"
            fill={props.fill}
        />
    </svg>
);

MailIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default MailIcon;
