import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const MessageFiiledIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M8.21354 22.6019C8.75395 22.6019 9.15215 22.3364 9.80632 21.7583L13.0582 19H17.544C20.3978 19 22 17.2464 22 14.4313V7.46445C22 4.64929 20.3978 3 17.544 3H6.45598C3.61173 3 2 4.64929 2 7.46445V14.4313C2 17.2559 3.65914 19 6.38962 19H7V21.218C7 22.0616 7.4456 22.6019 8.21354 22.6019Z"
            fill={props.fill}
        />
    </svg>
);

MessageFiiledIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default MessageFiiledIcon;
