import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const MessageOutlineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M8.21354 22.6019C8.75395 22.6019 9.15215 22.3364 9.80632 21.7583L13.0582 19H17.544C20.3978 19 22 17.2464 22 14.4313V7.46445C22 4.64929 20.3978 3 17.544 3H6.45598C3.61173 3 2 4.64929 2 7.46445V14.4313C2 17.2559 3.65914 19 6.38962 19H7V21.218C7 22.0616 7.4456 22.6019 8.21354 22.6019ZM9.01613 20.2588V17.7772C9.01613 17.218 8.76964 17 8.23871 17H6.52234C4.73995 17 4 16.0995 4 14.3744V7.52132C4 5.79621 4.73995 5 6.52234 5H17.4871C19.2601 5 20 5.79621 20 7.52132V14.3744C20 16.0995 19.2601 17 17.4871 17H13.2825C12.7042 17 12.4197 17.0948 12.0216 17.5119L9.01613 20.2588Z"
            fill={props.fill}
        />
    </svg>
);

MessageOutlineIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default MessageOutlineIcon;
