import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const OrdersFilledIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M9 5C9 3.34315 10.3431 2 12 2C13.6569 2 15 3.34315 15 5V7H9V5Z"
            stroke={props.fill}
            strokeWidth={2}
        />
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M2 10C2 7.79086 3.79086 6 6 6H18C20.2091 6 22 7.79086 22 10V17C22 19.2091 20.2091 21 18 21H6C3.79086 21 2 19.2091 2 17V10Z"
            fill={props.fill}
        />
    </svg>
);

OrdersFilledIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default OrdersFilledIcon;
