import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const PictureIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M3 7.8C3 6.11984 3 5.27976 3.32698 4.63803C3.6146 4.07354 4.07354 3.6146 4.63803 3.32698C5.27976 3 6.11984 3 7.8 3H16.2C17.8802 3 18.7202 3 19.362 3.32698C19.9265 3.6146 20.3854 4.07354 20.673 4.63803C21 5.27976 21 6.11984 21 7.8V16.2C21 17.8802 21 18.7202 20.673 19.362C20.3854 19.9265 19.9265 20.3854 19.362 20.673C18.7202 21 17.8802 21 16.2 21H7.8C6.11984 21 5.27976 21 4.63803 20.673C4.07354 20.3854 3.6146 19.9265 3.32698 19.362C3 18.7202 3 17.8802 3 16.2V7.8ZM7.48388 14.1481C7.66835 13.8369 8.07613 13.7396 8.38311 13.9334L10.8381 15.4833C11.1284 15.6666 11.5126 15.5907 11.7099 15.311L15.1246 10.3359C15.4275 9.90662 16.0941 10.0028 16.2611 10.5L19 18.1605C19.1389 18.5736 18.829 19 18.3902 19H5.5541C5.05691 19 4.74791 18.464 5 18.0388L7.48388 14.1481ZM10 8.0316C10 9.08834 9.06512 10.0159 8 10.0159C6.93488 10.0159 6 9.08834 6 8.0316C6 6.97486 6.93488 6.04735 8 6.04735C9.06512 6.04735 10 6.97486 10 8.0316Z"
            fill={props.fill}
        />
    </svg>
);

PictureIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default PictureIcon;
