import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const QuestionnaireIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M5 4C5 3.44771 5.44772 3 6 3H14V8H19V21C19 21.5523 18.5523 22 18 22H6C5.44771 22 5 21.5523 5 21V4Z"
            fill={props.fill}
        />
        <path
            d="M14 3H12L12 9C12 9.55228 12.4477 10 13 10H19V8H14V3Z"
            fill="white"
        />
        <path d="M14 8H19L14 3V8Z" fill={props.fill} />
        <path
            d="M7 14C7 13.4477 7.47533 13 8 13H16C16.5247 13 17 13.4477 17 14C17 14.5523 16.5247 15 16 15H8C7.47533 15 7 14.5523 7 14Z"
            fill="white"
        />
        <path
            d="M7 18C7 17.4477 7.47533 17 8 17H16C16.5247 17 17 17.4477 17 18C17 18.5523 16.5247 19 16 19H8C7.47533 19 7 18.5523 7 18Z"
            fill="white"
        />
    </svg>
);

QuestionnaireIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default QuestionnaireIcon;
