import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ShareFilledIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M19.9999 5.74999C19.9999 6.39084 19.8104 7.01739 19.4553 7.55085C19.1002 8.08431 18.5953 8.50088 18.0041 8.74818C17.4129 8.99548 16.7618 9.06247 16.1326 8.94074C15.5034 8.819 14.9242 8.51397 14.4679 8.06399L9.30994 10.906C9.56387 11.6147 9.56352 12.3896 9.30894 13.098L14.4649 15.938C15.0159 15.3941 15.743 15.0648 16.5152 15.0093C17.2874 14.9538 18.0541 15.1758 18.6772 15.6353C19.3003 16.0949 19.7388 16.7618 19.9139 17.5159C20.089 18.2701 19.9891 19.062 19.6322 19.749C19.2754 20.4361 18.6849 20.9732 17.9672 21.2636C17.2496 21.554 16.4518 21.5787 15.7175 21.3332C14.9833 21.0877 14.3608 20.5881 13.9621 19.9244C13.5634 19.2607 13.4148 18.4765 13.5429 17.713L8.06494 14.696C7.57577 15.0254 7.0062 15.2154 6.41727 15.2458C5.82833 15.2762 5.24222 15.1458 4.72174 14.8685C4.20126 14.5913 3.76604 14.1776 3.46269 13.6719C3.15935 13.1662 2.99932 12.5875 2.99976 11.9977C3.00019 11.408 3.16108 10.8295 3.46518 10.3243C3.76927 9.81898 4.20511 9.40598 4.726 9.12949C5.24689 8.853 5.83319 8.72345 6.42208 8.75472C7.01098 8.78599 7.58026 8.9769 8.06894 9.30699L13.5429 6.28899C13.4702 5.84637 13.4899 5.39349 13.6008 4.95886C13.7117 4.52422 13.9113 4.11725 14.1872 3.76354C14.463 3.40983 14.8091 3.11706 15.2036 2.90364C15.5982 2.69022 16.0326 2.56079 16.4796 2.52347C16.9266 2.48616 17.3765 2.54178 17.8009 2.68683C18.2254 2.83188 18.6152 3.06323 18.9459 3.3663C19.2766 3.66938 19.5409 4.03763 19.7223 4.44786C19.9037 4.8581 19.9983 5.30144 19.9999 5.74999Z"
            fill={props.fill}
        />
    </svg>
);

ShareFilledIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default ShareFilledIcon;
