import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ShareOutlineIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M17.25 9.25C16.2471 9.25 15.3428 8.82822 14.7047 8.15237L9.58284 10.9282C9.69138 11.266 9.75 11.6261 9.75 12C9.75 12.3754 9.6909 12.737 9.5815 13.076L14.7035 15.8489C15.3417 15.1723 16.2465 14.75 17.25 14.75C19.183 14.75 20.75 16.317 20.75 18.25C20.75 20.183 19.183 21.75 17.25 21.75C15.317 21.75 13.75 20.183 13.75 18.25C13.75 18.0405 13.7684 17.8354 13.8037 17.636L8.43855 14.7315C7.83919 15.2123 7.07819 15.5 6.25 15.5C4.317 15.5 2.75 13.933 2.75 12C2.75 10.067 4.317 8.5 6.25 8.5C7.07991 8.5 7.84235 8.78885 8.44228 9.27149L13.804 6.36568C13.7685 6.1658 13.75 5.96006 13.75 5.75C13.75 3.817 15.317 2.25 17.25 2.25C19.183 2.25 20.75 3.817 20.75 5.75C20.75 7.683 19.183 9.25 17.25 9.25ZM18.75 5.75C18.75 6.57843 18.0784 7.25 17.25 7.25C16.4216 7.25 15.75 6.57843 15.75 5.75C15.75 4.92157 16.4216 4.25 17.25 4.25C18.0784 4.25 18.75 4.92157 18.75 5.75ZM17.25 19.75C18.0784 19.75 18.75 19.0784 18.75 18.25C18.75 17.4216 18.0784 16.75 17.25 16.75C16.4216 16.75 15.75 17.4216 15.75 18.25C15.75 19.0784 16.4216 19.75 17.25 19.75ZM7.75 12C7.75 12.8284 7.07843 13.5 6.25 13.5C5.42157 13.5 4.75 12.8284 4.75 12C4.75 11.1716 5.42157 10.5 6.25 10.5C7.07843 10.5 7.75 11.1716 7.75 12Z"
            fill={props.fill}
        />
    </svg>
);

ShareOutlineIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default ShareOutlineIcon;
