import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SmokingRoomIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M7.11662 10.3734C6.77109 11.3383 6.11136 12.3989 5.30004 13C6.83211 12.3707 8.50553 10.9989 9.45677 9.00231C10.3135 7.20414 9.9731 6.02199 9.67319 4.9805C9.47362 4.2874 9.29197 3.6566 9.49302 2.94799C9.82846 1.76572 10.3813 0.639398 11 0C9.49695 0.912042 8.29559 2.09729 7.62114 3.51289C7.03594 4.74114 7.13236 6.35964 7.21733 7.78608C7.27926 8.82565 7.33511 9.76321 7.11662 10.3734Z"
            fill={props.fill}
        />
        <path
            d="M2.53303 11.4824C1.93361 12.414 1.83974 13.5866 2.25142 15C2.35701 14.1928 2.6624 13.5892 3.04508 13.163C3.23154 12.9554 3.48993 12.8208 3.78912 12.6651C4.33992 12.3782 5.02899 12.0194 5.66198 11C6.17545 10.1731 6.19714 8.93347 5.99999 8.00069C5.81676 8.63175 5.42866 9.04009 4.95664 9.47652C4.70731 9.70705 4.44454 9.85066 4.16945 10.001C3.66335 10.2776 3.11554 10.577 2.53303 11.4824Z"
            fill={props.fill}
        />
        <path
            d="M22.8842 12.0635C22.9827 12.0174 23.0263 11.901 22.9823 11.8015L21.1319 7.61894C21.0866 7.51664 20.9662 7.47135 20.8647 7.51846L6.21333 14.3202C5.7122 14.5529 5.4947 15.1478 5.72761 15.6488L7.34032 19.1178C7.38697 19.2181 7.50624 19.2615 7.60647 19.2146L22.8842 12.0635Z"
            fill={props.fill}
        />
        <path
            d="M3.91108 16.5016C3.67731 15.9987 3.89467 15.4016 4.39696 15.1666L6.09301 18.8149C6.32678 19.3177 6.10943 19.9149 5.60714 20.1498L3.91108 16.5016Z"
            fill={props.fill}
        />
        <path
            d="M2.57924 16.0168C2.07695 16.2518 1.8596 16.8489 2.09336 17.3518L3.78942 21C4.29171 20.7651 4.50906 20.1679 4.27529 19.6651L2.57924 16.0168Z"
            fill={props.fill}
        />
    </svg>
);

SmokingRoomIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default SmokingRoomIcon;
