import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const SuburbanIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M14.7 3.19999L15.8 0.999998H17V0.499999C17 0.2 16.8 0 16.5 0H7.49999C7.19999 0 6.99999 0.2 6.99999 0.499999V0.999998H8.19998L9.29998 3.19999C6.19999 3.59999 3.99999 4.69999 3.99999 5.99999V17C3.99999 17.6 4.39999 18 4.99999 18H19C19.6 18 20 17.6 20 17V5.99999C20 4.69999 17.8 3.59999 14.7 3.19999ZM14.5011 1.00005L13.5011 3.10004C13.0011 3.00004 12.5011 3.00004 12.0011 3.00004C11.5012 3.00004 11.0012 3.00004 10.5012 3.10004L9.50115 1.00005H14.5011ZM12.0011 6.99994C12.6011 6.99994 13.0011 6.59994 13.0011 5.99994C13.0011 5.39994 12.6011 4.99994 12.0011 4.99994C11.4012 4.99994 11.0012 5.39994 11.0012 5.99994C11.0012 6.59994 11.4012 6.99994 12.0011 6.99994ZM8.99959 15.9999H5.9996V13.9999H8.99959V15.9999ZM14.9996 15.9999H17.9996V13.9999H14.9996V15.9999ZM17.9996 11.9999H5.9996V7.99994H17.9996V11.9999ZM7.80116 21H7.00116C5.90116 21 5.00116 20.1 5.00116 19H19.0011C19.0011 20.1 18.1011 21 17.0011 21H16.3011L17.8011 24H15.8011L14.3011 21H9.70115L8.20116 24H6.30116L7.80116 21Z"
            fill={props.fill}
        />
    </svg>
);

SuburbanIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default SuburbanIcon;
