import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const TicketReturnIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M12 17C13.3261 17 14.5979 16.4732 15.5355 15.5355C16.4732 14.5979 17 13.3261 17 12C17 10.6739 16.4732 9.40215 15.5355 8.46447C14.5979 7.52679 13.3261 7 12 7C10.7739 7.001 9.59193 7.45795 8.684 8.282L11 10.402L3.998 12.127L5.099 5L7.196 6.92C8.49104 5.68634 10.2114 4.99877 12 5C13.8565 5 15.637 5.7375 16.9497 7.05025C18.2625 8.36301 19 10.1435 19 12C19 13.8565 18.2625 15.637 16.9497 16.9497C15.637 18.2625 13.8565 19 12 19C10.7005 18.9994 9.42682 18.6368 8.32182 17.9529C7.21682 17.269 6.32419 16.2908 5.744 15.128L7.545 14.227C8.367 15.865 10.043 17 12 17Z"
            fill={props.fill}
        />
    </svg>
);

TicketReturnIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default TicketReturnIcon;
