import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ViewOnCityIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M10 18.2V23H21.4C21.7314 23 22 22.7314 22 22.4V8.6C22 8.26863 21.7314 8 21.4 8H16.4464L16.2883 10H20V11H16.2092L16.051 13H20V14H15.9719L15.599 18.7155C15.5855 18.886 15.4407 19.0129 15.2756 18.999C15.1199 18.9858 15 18.8516 15 18.6903V2.4C15 2.17909 14.8209 2 14.6 2H14V1.4C14 1.17909 13.8209 1 13.6 1H3.4C3.17909 1 3 1.17909 3 1.4V2H2.4C2.17909 2 2 2.17909 2 2.4V22.4C2 22.7314 2.26863 23 2.6 23H7V18.2C7 18.0895 7.08954 18 7.2 18H9.8C9.91046 18 10 18.0895 10 18.2ZM5.5 15V9H7.5V15H5.5ZM9.5 9V15H11.5V9H9.5ZM5.5 7V4H7.5V7H5.5ZM9.5 4V7H11.5V4H9.5ZM17 17V16H20V17H17Z"
            fill={props.fill}
        />
        <path
            d="M16.5255 7L16.6046 6H19.6C19.8209 6 20 6.17909 20 6.4V7H16.5255Z"
            fill={props.fill}
        />
    </svg>
);

ViewOnCityIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default ViewOnCityIcon;
