import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ViewOnGardenIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M7.84542 6.92911V7C9.41101 7 10.9971 6.87444 12.3926 6.60107L10.9667 9.16326C10.9555 9.18351 10.9449 9.20413 10.9351 9.22511C10.7007 9.72519 10.916 10.3206 11.4161 10.555L12.4279 11.0293L9.79794 15.4125C8.81782 15.8187 7.7828 16 6.84542 16C4.19448 16 0.762708 14.4383 0 10.625C1.30054 11.5861 3.53579 12 5.84542 12V11.9392C2.97241 11.587 0.662175 9.73943 0.0221996 7.34583C0.575042 5.45412 1.89387 4.47257 3.41041 3.34388C4.57615 2.47627 5.85871 1.52172 7 0C9.37634 1.18817 11.2452 2.32592 12.4963 4.13213C11.409 5.61649 9.751 6.65654 7.84542 6.92911Z"
            fill={props.fill}
        />
        <path
            d="M8 17L8.17985 23.2947C8.19088 23.6809 7.8808 24 7.49441 24H6.50559C6.1192 24 5.80912 23.6809 5.82015 23.2947L6 17H8Z"
            fill={props.fill}
        />
        <path
            d="M16 20H18L18.164 23.28C18.1836 23.6717 17.8713 24 17.4791 24H16.5209C16.1287 24 15.8164 23.6717 15.836 23.28L16 20Z"
            fill={props.fill}
        />
        <path
            d="M20.9344 11.2557L23.6687 17.2711C23.8058 17.5728 23.6724 17.9285 23.3708 18.0656C23.3189 18.0892 23.2639 18.1053 23.2075 18.1134L17.0099 19L10.7929 18.1131C10.4649 18.0663 10.2369 17.7624 10.2837 17.4344C10.2917 17.3779 10.3078 17.3228 10.3314 17.2708L13.0656 11.2557L16.5756 12.901C16.8445 13.0271 17.1555 13.0271 17.4244 12.901L20.9344 11.2557Z"
            fill={props.fill}
        />
        <path
            d="M17.1789 0.536656C17.2563 0.575362 17.3191 0.638131 17.3578 0.715542L21.8056 9.61118C21.9044 9.80877 21.8243 10.049 21.6267 10.1478C21.6168 10.1528 21.6067 10.1573 21.5964 10.1615L17.3714 11.8514C17.133 11.9468 16.867 11.9468 16.6286 11.8514L12.4036 10.1615C12.1985 10.0794 12.0987 9.84662 12.1944 9.61118L16.6422 0.715542C16.741 0.51795 16.9813 0.437861 17.1789 0.536656Z"
            fill={props.fill}
        />
    </svg>
);

ViewOnGardenIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default ViewOnGardenIcon;
