import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ViewOnHippodromeIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M14.0339 8.57063L11.5812 7.48054C11.6308 7.59605 11.7023 7.70227 11.7929 7.79289L12.2541 8.25414C11.9629 9.38875 11.4271 10.0935 10.7235 10.3683L12.5 12.5L12.8794 12.3103C13.2355 12.1322 13.4065 11.7195 13.2806 11.3418L12.5 9H13.2127C13.542 9 13.8482 8.83807 14.0339 8.57063ZM14.583 7.72198C16.0415 5.76637 18.3728 4.5 21 4.5H24C24 4.80643 23.8269 5.08657 23.5528 5.22361L22.9565 5.52174L22.5153 10.8166C22.5066 10.9203 22.42 11 22.316 11H21.7208C21.2903 11 20.9082 10.7246 20.7721 10.3162L20.285 8.85513C20.1052 8.31558 20.1845 7.72322 20.5 7.25L20.6641 7.00385C20.7574 6.86386 20.8322 6.71344 20.8873 6.55635L20.6582 6.6709C20.2404 6.87978 19.9348 7.26079 19.8215 7.71392L18.5681 12.7276C18.5099 12.9604 18.4254 13.1811 18.3182 13.3869C18.1768 13.7914 18.1671 14.2236 18.2883 14.6277L20.3455 21.4851C20.409 21.6967 20.2889 21.9197 20.0773 21.9831C20.04 21.9943 20.0013 22 19.9624 22H19.2538C19.0989 22 18.9579 21.9105 18.8919 21.7703L15.9759 15.5739C15.811 15.2233 15.4584 14.9996 15.0711 14.9997L8.15636 15C7.66228 15 7.18568 15.1829 6.81843 15.5134L3.71361 18.3078C3.57403 18.4334 3.47264 18.5958 3.42105 18.7763L2.54144 21.8549C2.51691 21.9408 2.43844 22 2.34914 22H1.72345C1.613 22 1.52345 21.9105 1.52345 21.8C1.52345 21.7951 1.67164 20.4577 1.968 17.788C1.9889 17.5999 2.06277 17.4215 2.18102 17.2737L3.30503 15.8687C3.69588 15.3802 3.83558 14.7369 3.68256 14.1302C3.56098 13.6482 3.50013 13.1054 3.5 12.5019C3.5 11.8805 3.66159 11.2971 3.94499 10.7914C3.64642 10.9025 3.4059 11.1541 3.3228 11.4865C3.31753 11.5075 3.31295 11.5288 3.30907 11.5501L2.98166 13.3508C2.86762 13.9781 2.49814 14.4945 2 14.8123V14L1.38023 15.0846C1.07729 15.165 0.752305 15.1816 0.423524 15.1219C0.278626 15.0955 0.13674 15.0547 0 15L1.90429 10.4297C2.25499 9.58801 3.13061 9.09009 4.03328 9.21904L5.35808 9.4083C5.84774 9.14766 6.40662 9 7 9H9.625L9.5 8.5H9C9.33333 7.5 9.5 6.66667 9.5 6C9.5 5 9 4 10 3H11C12 3.66667 12.5 4.66667 12.5 6C12.5 6.11228 12.4986 6.22247 12.4958 6.33055L14.583 7.72198ZM8 15.8418V18.2344C8 18.4085 8.04541 18.5795 8.13176 18.7306L9.82901 21.7008C9.88381 21.7967 9.8505 21.9188 9.75459 21.9736C9.72437 21.9909 9.69017 22 9.65536 22H9.09368C9.03432 22 8.97803 21.9736 8.94003 21.928L6.64644 19.1757C6.55006 19.0601 6.48104 18.9241 6.44452 18.7781L6.13098 17.5239L8 15.8418ZM15.25 16L13.0487 21.8702C13.0194 21.9483 12.9448 22 12.8614 22H12.241C12.1305 22 12.041 21.9105 12.041 21.8C12.041 21.7876 12.0421 21.7753 12.0444 21.7631L13.125 16H15.25ZM11.2 2.6H10.4948C10.1692 2.2888 9.82644 2.0888 9.4665 2C9.36037 1.80718 9.3 1.58564 9.3 1.35C9.3 0.604416 9.90442 0 10.65 0C11.3956 0 12 0.604416 12 1.35C12 1.382 11.9989 1.41374 11.9967 1.44518L11.6 1.53333V2.2C11.6 2.42091 11.4209 2.6 11.2 2.6Z"
            fill={props.fill}
        />
    </svg>
);

ViewOnHippodromeIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default ViewOnHippodromeIcon;
