import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const ViewOnMountainIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 24 24"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M12.0454 21.9744C12.0922 21.9797 12.1399 21.9769 12.1864 21.9655L23.6928 19.1457C23.9731 19.077 24.0906 18.7432 23.9153 18.5141L15.4235 7.41523C15.2634 7.20598 14.9483 7.20598 14.7882 7.41523L8.25051 15.96L11.9158 7.42673L9.33696 2.65169C9.18579 2.3718 8.78422 2.3718 8.63306 2.65169L0.0496962 18.5446C-0.0747404 18.775 0.0521025 19.0609 0.306439 19.1232L11.9045 21.9655C11.9509 21.9769 11.9986 21.9797 12.0454 21.9744Z"
            fill={props.fill}
        />
    </svg>
);

ViewOnMountainIcon.defaultProps = {
    width: 24,
    height: 24,
    fill: 'currentColor',
};

export default ViewOnMountainIcon;
