import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CameraIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 36 36"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M11.0136 7.47676C11.6463 6.39204 11.9627 5.84968 12.4034 5.45536C12.7934 5.10645 13.252 4.84302 13.7499 4.68198C14.3125 4.5 14.9404 4.5 16.1963 4.5H19.8038C21.0596 4.5 21.6875 4.5 22.2501 4.68198C22.748 4.84302 23.2067 5.10645 23.5967 5.45536C24.0374 5.84968 24.3537 6.39204 24.9864 7.47678L25.875 9H27C29.1002 9 30.1503 9 30.9525 9.40872C31.6581 9.76826 32.2317 10.3419 32.5913 11.0475C33 11.8497 33 12.8998 33 15V24C33 26.1001 33 27.1503 32.5913 27.9525C32.2317 28.6581 31.6581 29.2317 30.9525 29.5913C30.1503 30 29.1002 30 27 30H9C6.89981 30 5.8497 30 5.04753 29.5913C4.34193 29.2317 3.76826 28.6581 3.40872 27.9525C3 27.1503 3 26.1001 3 24V15C3 12.8998 3 11.8497 3.40872 11.0475C3.76826 10.3419 4.34193 9.76826 5.04753 9.40872C5.8497 9 6.89981 9 9 9H10.125L11.0136 7.47676ZM18 25.575C21.9351 25.575 25.125 22.3851 25.125 18.45C25.125 14.515 21.9351 11.325 18 11.325C14.065 11.325 10.875 14.515 10.875 18.45C10.875 22.3851 14.065 25.575 18 25.575ZM22.05 18.45C22.05 20.6868 20.2368 22.5 18 22.5C15.7632 22.5 13.95 20.6868 13.95 18.45C13.95 16.2132 15.7632 14.4 18 14.4C20.2368 14.4 22.05 16.2132 22.05 18.45Z"
            fill={props.fill}
        />
    </svg>
);

CameraIcon.defaultProps = {
    width: 36,
    height: 36,
    fill: 'currentColor',
};

export default CameraIcon;
