import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const CovidShildIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 36 36"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            fillRule="evenodd"
            clipRule="evenodd"
            d="M18 6C14.8571 7.5 10.9286 9.20745 7 9L7.78571 19.2516C7.78571 21.5075 8.97122 23.6215 10.9618 24.9152L18 30L25.0382 24.9152C27.0288 23.6215 28.2143 21.5075 28.2143 19.2516L29 9C25.0714 9.20745 21.1429 7.5 18 6ZM22.5393 11.7641C22.3551 12.1415 21.8886 12.3117 21.3966 12.2213L20.2633 14.1843C20.8283 14.6022 21.2737 15.1726 21.5387 15.8347L23.0375 15.4331C23.0408 14.9565 23.2764 14.5483 23.6624 14.4277C24.1734 14.2681 24.7545 14.6729 24.9603 15.3319C25.1662 15.9908 24.9188 16.6544 24.4078 16.814C24.0356 16.9303 23.6262 16.747 23.3517 16.3842L21.7843 16.8042C21.8014 16.9504 21.8101 17.0992 21.8101 17.25C21.8101 17.7644 21.7082 18.255 21.5234 18.7027L23.4636 19.8229C23.7977 19.5599 24.2085 19.4836 24.5312 19.6638C24.9986 19.9249 25.1045 20.6251 24.7679 21.2278C24.4312 21.8305 23.7795 22.1075 23.3121 21.8465C22.9417 21.6395 22.7983 21.1567 22.9224 20.6651L21.0237 19.5689C20.6503 20.0551 20.1623 20.4488 19.6 20.7094L20.2451 23.1168C20.7479 23.1223 21.1751 23.3808 21.2825 23.7886C21.4187 24.3063 20.988 24.8684 20.3204 25.0442C19.6528 25.2199 19.0011 24.9428 18.8648 24.4251C18.77 24.065 18.9496 23.6833 19.2925 23.4252L18.6444 21.0065C18.4347 21.0422 18.2192 21.0609 17.9993 21.0609C17.4577 21.0609 16.9425 20.9479 16.4759 20.7442L15.3714 22.6574C15.6971 23.0063 15.8066 23.4656 15.6085 23.8188C15.3465 24.2856 14.6461 24.3902 14.0441 24.0524C13.442 23.7146 13.1663 23.0623 13.4282 22.5955C13.619 22.2555 14.0422 22.1077 14.4907 22.1828L15.6199 20.227C15.1349 19.8388 14.7469 19.3347 14.4978 18.7566L13.3157 19.0733L13.3084 19.0752C13.2819 19.5187 13.0513 19.8905 12.686 20.0046C12.175 20.1642 11.5939 19.7594 11.3881 19.1005C11.1822 18.4415 11.4296 17.7779 11.9406 17.6183C12.3339 17.4955 12.7688 17.7071 13.0421 18.1116L13.0569 18.1074L14.2269 17.7939C14.2015 17.6163 14.1884 17.4347 14.1884 17.25C14.1884 16.7327 14.2915 16.2396 14.4782 15.7898L12.4298 14.6072C12.0907 14.8977 11.6607 14.9899 11.3241 14.8044C10.8553 14.546 10.7455 13.8464 11.0788 13.2418C11.4121 12.6372 12.0623 12.3566 12.5311 12.6151C12.8906 12.8133 13.039 13.2709 12.9383 13.7461L14.9798 14.9248C15.4136 14.3622 16.0012 13.9242 16.6796 13.6738L16.5524 13.1991C16.0853 13.1682 15.6977 12.916 15.5961 12.5304C15.4598 12.0127 15.8906 11.4506 16.5582 11.2748C17.2258 11.099 17.8775 11.3762 18.0138 11.8939C18.1146 12.2769 17.905 12.6843 17.5187 12.9415L17.6561 13.4544C17.7691 13.4443 17.8836 13.4391 17.9993 13.4391C18.4893 13.4391 18.9578 13.5316 19.3881 13.7001L20.5216 11.7369C20.2321 11.416 20.1285 11.0038 20.2928 10.6673C20.5276 10.1863 21.2209 10.0418 21.8413 10.3447C22.4617 10.6476 22.7742 11.2831 22.5393 11.7641Z"
            fill={props.fill}
        />
    </svg>
);

CovidShildIcon.defaultProps = {
    width: 36,
    height: 36,
    fill: 'currentColor',
};

export default CovidShildIcon;
