import {ReactElement} from 'react';

import {IIconProps} from 'icons/types/icon';

const HeartFilledIcon = (props: IIconProps): ReactElement => (
    <svg
        {...props}
        viewBox="0 0 36 36"
        fill="none"
        xmlns="http://www.w3.org/2000/svg"
        focusable="false"
    >
        <path
            d="M18.4766 29.3538C18.3359 29.4491 18.1699 29.5 18 29.5C17.8301 29.5 17.6642 29.4491 17.5234 29.3538C15.2676 27.846 5.78003 21.1362 5.78003 14.8054C5.78003 6.63669 15.3727 5.32823 18 10.8311C20.6273 5.32823 30.22 6.63669 30.22 14.8054C30.22 21.1374 20.7324 27.846 18.4766 29.3514V29.3538Z"
            fill={props.fill}
        />
    </svg>
);

HeartFilledIcon.defaultProps = {
    width: 36,
    height: 36,
    fill: 'currentColor',
};

export default HeartFilledIcon;
